/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Arrays;
import java.util.List;
import java.util.function.IntSupplier;
import org.neo4j.cursor.Cursor;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.cursor.NodeItemHelper;
import org.neo4j.kernel.api.cursor.RelationshipItemHelper;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.util.Cursors;
import org.neo4j.storageengine.api.DegreeItem;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.LabelItem;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;

public class StubCursors {
    public static Cursor<NodeItem> asNodeCursor(long nodeId) {
        return StubCursors.asNodeCursor(nodeId, (Cursor<PropertyItem>)Cursors.empty(), (Cursor<LabelItem>)Cursors.empty());
    }

    public static Cursor<NodeItem> asNodeCursor(long ... nodeIds) {
        Object[] nodeItems = new NodeItem[nodeIds.length];
        for (int i = 0; i < nodeIds.length; ++i) {
            nodeItems[i] = StubCursors.asNode(nodeIds[i]);
        }
        return Cursors.cursor((Object[])nodeItems);
    }

    public static Cursor<NodeItem> asNodeCursor(long nodeId, Cursor<PropertyItem> propertyCursor, Cursor<LabelItem> labelCursor) {
        return Cursors.cursor((Object[])new NodeItem[]{StubCursors.asNode(nodeId, propertyCursor, labelCursor)});
    }

    public static NodeItem asNode(long nodeId) {
        return StubCursors.asNode(nodeId, (Cursor<PropertyItem>)Cursors.empty(), (Cursor<LabelItem>)Cursors.empty());
    }

    public static NodeItem asNode(final long nodeId, final Cursor<PropertyItem> propertyCursor, final Cursor<LabelItem> labelCursor) {
        return new NodeItemHelper(){

            public long id() {
                return nodeId;
            }

            public Cursor<LabelItem> label(final int labelId) {
                return new Cursor<LabelItem>(){
                    Cursor<LabelItem> cursor;
                    {
                        this.cursor = this.labels();
                    }

                    public boolean next() {
                        while (this.cursor.next()) {
                            if (((LabelItem)this.cursor.get()).getAsInt() != labelId) continue;
                            return true;
                        }
                        return false;
                    }

                    public void close() {
                        this.cursor.close();
                    }

                    public LabelItem get() {
                        return (LabelItem)this.cursor.get();
                    }
                };
            }

            public Cursor<LabelItem> labels() {
                return labelCursor;
            }

            public Cursor<PropertyItem> property(final int propertyKeyId) {
                return new Cursor<PropertyItem>(){
                    Cursor<PropertyItem> cursor;
                    {
                        this.cursor = this.properties();
                    }

                    public boolean next() {
                        while (this.cursor.next()) {
                            if (((PropertyItem)this.cursor.get()).propertyKeyId() != propertyKeyId) continue;
                            return true;
                        }
                        return false;
                    }

                    public void close() {
                        this.cursor.close();
                    }

                    public PropertyItem get() {
                        return (PropertyItem)this.cursor.get();
                    }
                };
            }

            public Cursor<PropertyItem> properties() {
                return propertyCursor;
            }

            public Cursor<RelationshipItem> relationships(Direction direction, int ... relTypes) {
                throw new UnsupportedOperationException();
            }

            public Cursor<RelationshipItem> relationships(Direction direction) {
                throw new UnsupportedOperationException();
            }

            public Cursor<IntSupplier> relationshipTypes() {
                throw new UnsupportedOperationException();
            }

            public int degree(Direction direction) {
                throw new UnsupportedOperationException();
            }

            public int degree(Direction direction, int relType) {
                throw new UnsupportedOperationException();
            }

            public boolean isDense() {
                throw new UnsupportedOperationException();
            }

            public Cursor<DegreeItem> degrees() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static RelationshipItem asRelationship(final long relId, final int type, final long startNode, final long endNode, final Cursor<PropertyItem> propertyCursor) {
        return new RelationshipItemHelper(){

            public long id() {
                return relId;
            }

            public int type() {
                return type;
            }

            public long startNode() {
                return startNode;
            }

            public long endNode() {
                return endNode;
            }

            public long otherNode(long nodeId) {
                return startNode == nodeId ? endNode : startNode;
            }

            public Cursor<PropertyItem> property(final int propertyKeyId) {
                return new Cursor<PropertyItem>(){
                    Cursor<PropertyItem> cursor;
                    {
                        this.cursor = this.properties();
                    }

                    public boolean next() {
                        while (this.cursor.next()) {
                            if (((PropertyItem)this.cursor.get()).propertyKeyId() != propertyKeyId) continue;
                            return true;
                        }
                        return false;
                    }

                    public void close() {
                        this.cursor.close();
                    }

                    public PropertyItem get() {
                        return (PropertyItem)this.cursor.get();
                    }
                };
            }

            public Cursor<PropertyItem> properties() {
                return propertyCursor;
            }
        };
    }

    public static Cursor<RelationshipItem> asRelationshipCursor(final long relId, final int type, final long startNode, final long endNode, final Cursor<PropertyItem> propertyCursor) {
        return Cursors.cursor((Object[])new RelationshipItem[]{new RelationshipItemHelper(){

            public long id() {
                return relId;
            }

            public int type() {
                return type;
            }

            public long startNode() {
                return startNode;
            }

            public long endNode() {
                return endNode;
            }

            public long otherNode(long nodeId) {
                return startNode == nodeId ? endNode : startNode;
            }

            public Cursor<PropertyItem> properties() {
                return propertyCursor;
            }

            public Cursor<PropertyItem> property(final int propertyKeyId) {
                return new Cursor<PropertyItem>(){
                    Cursor<PropertyItem> cursor;
                    {
                        this.cursor = this.properties();
                    }

                    public boolean next() {
                        while (this.cursor.next()) {
                            if (((PropertyItem)this.cursor.get()).propertyKeyId() != propertyKeyId) continue;
                            return true;
                        }
                        return false;
                    }

                    public void close() {
                        this.cursor.close();
                    }

                    public PropertyItem get() {
                        return (PropertyItem)this.cursor.get();
                    }
                };
            }
        }});
    }

    public static Cursor<LabelItem> asLabelCursor(Integer ... labels) {
        return StubCursors.asLabelCursor(Arrays.asList(labels));
    }

    public static Cursor<LabelItem> asLabelCursor(List<Integer> labels) {
        return Cursors.cursor((Iterable)Iterables.map(integer -> () -> integer, labels));
    }

    public static Cursor<PropertyItem> asPropertyCursor(DefinedProperty ... properties) {
        return Cursors.cursor((Iterable)Iterables.map(property -> new PropertyItem((DefinedProperty)property){
            final /* synthetic */ DefinedProperty val$property;
            {
                this.val$property = definedProperty;
            }

            public int propertyKeyId() {
                return this.val$property.propertyKeyId();
            }

            public Object value() {
                return this.val$property.value();
            }
        }, Arrays.asList(properties)));
    }
}

