/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.TransactionHook;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;

public class TransactionHookIT
extends KernelIntegrationTest {
    @Test
    public void shouldRecieveTxStateOnCommit() throws Exception {
        TransactionHook hook = (TransactionHook)Mockito.mock(TransactionHook.class);
        this.kernel.registerTransactionHook(hook);
        DataWriteOperations ops = this.dataWriteOperationsInNewTransaction();
        ops.nodeCreate();
        this.commit();
        ((TransactionHook)Mockito.verify((Object)hook)).beforeCommit((ReadableTransactionState)Matchers.any(ReadableTransactionState.class), (KernelTransaction)Matchers.any(KernelTransaction.class), (StoreReadLayer)Matchers.any(StoreReadLayer.class), (StorageStatement)Matchers.any(StorageStatement.class));
        ((TransactionHook)Mockito.verify((Object)hook)).afterCommit((ReadableTransactionState)Matchers.any(ReadableTransactionState.class), (KernelTransaction)Matchers.any(KernelTransaction.class), (TransactionHook.Outcome)Matchers.any(TransactionHook.Outcome.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{hook});
    }

    @Test
    public void shouldRollbackOnFailureInBeforeCommit() throws Exception {
        TransactionHook hook = (TransactionHook)Mockito.mock(TransactionHook.class);
        String message = "Original";
        Mockito.when((Object)hook.beforeCommit((ReadableTransactionState)Matchers.any(ReadableTransactionState.class), (KernelTransaction)Matchers.any(KernelTransaction.class), (StoreReadLayer)Matchers.any(StoreReadLayer.class), (StorageStatement)Matchers.any(StorageStatement.class))).thenReturn((Object)new TransactionHook.Outcome(){

            public boolean isSuccessful() {
                return false;
            }

            public Throwable failure() {
                return new Throwable("Original");
            }
        });
        this.kernel.registerTransactionHook(hook);
        DataWriteOperations ops = this.dataWriteOperationsInNewTransaction();
        ops.nodeCreate();
        try {
            this.commit();
            TestCase.fail((String)"Expected this to fail.");
        }
        catch (TransactionFailureException e) {
            Assert.assertThat((Object)e.getCause().getMessage(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"Transaction handler failed."));
            Assert.assertThat((Object)e.getCause().getCause().getMessage(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"Original"));
        }
        ((TransactionHook)Mockito.verify((Object)hook)).beforeCommit((ReadableTransactionState)Matchers.any(ReadableTransactionState.class), (KernelTransaction)Matchers.any(KernelTransaction.class), (StoreReadLayer)Matchers.any(StoreReadLayer.class), (StorageStatement)Matchers.any(StorageStatement.class));
        ((TransactionHook)Mockito.verify((Object)hook)).afterRollback((ReadableTransactionState)Matchers.any(ReadableTransactionState.class), (KernelTransaction)Matchers.any(KernelTransaction.class), (TransactionHook.Outcome)Matchers.any(TransactionHook.Outcome.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{hook});
    }
}

