/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.guard.TimeoutGuard;
import org.neo4j.kernel.impl.api.GuardingStatementOperations;
import org.neo4j.kernel.impl.api.StatementOperationContainer;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.CleanupRule;

public class GuardIT {
    @Rule
    public CleanupRule cleanupRule = new CleanupRule();

    @Test
    public void useTimeoutGuard() throws Exception {
        GraphDatabaseAPI database = this.startDataBase();
        DependencyResolver dependencyResolver = database.getDependencyResolver();
        Guard guard = (Guard)dependencyResolver.resolveDependency(Guard.class);
        Assert.assertThat((Object)guard, (Matcher)Matchers.instanceOf(TimeoutGuard.class));
    }

    @Test
    public void includeGuardingOperationLayerOnGuardingParts() throws Exception {
        GraphDatabaseAPI database = this.startDataBase();
        DependencyResolver dependencyResolver = database.getDependencyResolver();
        StatementOperationContainer operationParts = (StatementOperationContainer)dependencyResolver.resolveDependency(StatementOperationContainer.class);
        StatementOperationParts guardedParts = operationParts.guardedParts();
        Assert.assertThat((Object)guardedParts.entityReadOperations(), (Matcher)Matchers.instanceOf(GuardingStatementOperations.class));
        Assert.assertThat((Object)guardedParts.entityWriteOperations(), (Matcher)Matchers.instanceOf(GuardingStatementOperations.class));
    }

    @Test
    public void notIncludeGuardingOperationLayerOnNonGuardingParts() throws Exception {
        GraphDatabaseAPI database = this.startDataBase();
        DependencyResolver dependencyResolver = database.getDependencyResolver();
        StatementOperationContainer operationParts = (StatementOperationContainer)dependencyResolver.resolveDependency(StatementOperationContainer.class);
        StatementOperationParts guardedParts = operationParts.nonGuarderParts();
        Assert.assertThat((Object)guardedParts.entityReadOperations(), (Matcher)Matchers.not((Matcher)Matchers.instanceOf(GuardingStatementOperations.class)));
        Assert.assertThat((Object)guardedParts.entityWriteOperations(), (Matcher)Matchers.not((Matcher)Matchers.instanceOf(GuardingStatementOperations.class)));
    }

    private GraphDatabaseAPI startDataBase() {
        GraphDatabaseAPI database = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
        this.cleanupRule.add(database);
        return database;
    }
}

