/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Iterator;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.SchemaWriteOperations;
import org.neo4j.kernel.api.TokenWriteOperations;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;

public class IndexIT
extends KernelIntegrationTest {
    private static final String LABEL = "Label";
    private static final String PROPERTY_KEY = "prop";
    private int labelId;
    private int propertyKeyId;

    @Before
    public void createLabelAndProperty() throws Exception {
        TokenWriteOperations tokenWrites = this.tokenWriteOperationsInNewTransaction();
        this.labelId = tokenWrites.labelGetOrCreateForName(LABEL);
        this.propertyKeyId = tokenWrites.propertyKeyGetOrCreateForName(PROPERTY_KEY);
        this.commit();
    }

    @Test
    public void addIndexRuleInATransaction() throws Exception {
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        IndexDescriptor expectedRule = statement.indexCreate(this.labelId, this.propertyKeyId);
        this.commit();
        statement = this.schemaWriteOperationsInNewTransaction();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new IndexDescriptor[]{expectedRule}), (Object)Iterators.asSet((Iterator)statement.indexesGetForLabel(this.labelId)));
        Assert.assertEquals((Object)expectedRule, (Object)statement.indexGetForLabelAndPropertyKey(this.labelId, this.propertyKeyId));
        this.commit();
    }

    @Test
    public void committedAndTransactionalIndexRulesShouldBeMerged() throws Exception {
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        IndexDescriptor existingRule = statement.indexCreate(this.labelId, this.propertyKeyId);
        this.commit();
        SchemaWriteOperations statement2 = this.schemaWriteOperationsInNewTransaction();
        int propertyKey2 = 10;
        IndexDescriptor addedRule = statement2.indexCreate(this.labelId, propertyKey2);
        Set indexRulesInTx = Iterators.asSet((Iterator)statement2.indexesGetForLabel(this.labelId));
        this.commit();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new IndexDescriptor[]{existingRule, addedRule}), (Object)indexRulesInTx);
    }

    @Test
    public void rollBackIndexRuleShouldNotBeCommitted() throws Exception {
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        statement.indexCreate(this.labelId, this.propertyKeyId);
        this.rollback();
        statement = this.schemaWriteOperationsInNewTransaction();
        Assert.assertEquals((Object)Iterators.emptySetOf(IndexDescriptor.class), (Object)Iterators.asSet((Iterator)statement.indexesGetForLabel(this.labelId)));
        this.commit();
    }

    @Test
    public void shouldRemoveAConstraintIndexWithoutOwnerInRecovery() throws Exception {
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> this.kernel, this.indexingService);
        creator.createConstraintIndex(this.labelId, this.propertyKeyId);
        this.restartDb();
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        Assert.assertEquals((Object)Iterators.emptySetOf(IndexDescriptor.class), (Object)Iterators.asSet((Iterator)statement.indexesGetForLabel(this.labelId)));
        this.commit();
    }

    @Test
    public void shouldDisallowDroppingIndexThatDoesNotExist() throws Exception {
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        IndexDescriptor index = statement.indexCreate(this.labelId, this.propertyKeyId);
        this.commit();
        statement = this.schemaWriteOperationsInNewTransaction();
        statement.indexDrop(index);
        this.commit();
        try {
            statement = this.schemaWriteOperationsInNewTransaction();
            statement.indexDrop(index);
            this.commit();
        }
        catch (SchemaKernelException e) {
            Assert.assertEquals((Object)("Unable to drop index on :label[" + this.labelId + "](property[" + this.propertyKeyId + "]): No such INDEX ON :label[" + this.labelId + "](property[" + this.propertyKeyId + "])."), (Object)e.getMessage());
        }
    }

    @Test
    public void shouldFailToCreateIndexWhereAConstraintAlreadyExists() throws Exception {
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        statement.uniquePropertyConstraintCreate(this.labelId, this.propertyKeyId);
        this.commit();
        try {
            statement = this.schemaWriteOperationsInNewTransaction();
            statement.indexCreate(this.labelId, this.propertyKeyId);
            this.commit();
            Assert.fail((String)"expected exception");
        }
        catch (SchemaKernelException e) {
            Assert.assertEquals((Object)"Label 'Label' and property 'prop' have a unique constraint defined on them, so an index is already created that matches this.", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldListConstraintIndexesInTheBeansAPI() throws Exception {
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        statement.uniquePropertyConstraintCreate(statement.labelGetOrCreateForName("Label1"), statement.propertyKeyGetOrCreateForName("property1"));
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            Set indexes = Iterables.asSet((Iterable)this.db.schema().getIndexes());
            Assert.assertEquals((long)1L, (long)indexes.size());
            IndexDefinition index = (IndexDefinition)indexes.iterator().next();
            Assert.assertEquals((Object)"Label1", (Object)index.getLabel().name());
            Assert.assertEquals((Object)Iterators.asSet((Object[])new String[]{"property1"}), (Object)Iterables.asSet((Iterable)index.getPropertyKeys()));
            Assert.assertTrue((String)"index should be a constraint index", (boolean)index.isConstraintIndex());
            try {
                index.drop();
                Assert.fail((String)"expected exception");
            }
            catch (IllegalStateException e) {
                Assert.assertEquals((Object)"Constraint indexes cannot be dropped directly, instead drop the owning uniqueness constraint.", (Object)e.getMessage());
            }
        }
    }

    @Test
    public void shouldNotListConstraintIndexesAmongIndexes() throws Exception {
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        statement.uniquePropertyConstraintCreate(this.labelId, this.propertyKeyId);
        this.commit();
        statement = this.schemaWriteOperationsInNewTransaction();
        Assert.assertFalse((boolean)statement.indexesGetAll().hasNext());
        Assert.assertFalse((boolean)statement.indexesGetForLabel(this.labelId).hasNext());
    }

    @Test
    public void shouldNotListIndexesAmongConstraintIndexes() throws Exception {
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        statement.indexCreate(this.labelId, this.propertyKeyId);
        this.commit();
        statement = this.schemaWriteOperationsInNewTransaction();
        Assert.assertFalse((boolean)statement.uniqueIndexesGetAll().hasNext());
        Assert.assertFalse((boolean)statement.uniqueIndexesGetForLabel(this.labelId).hasNext());
    }
}

