/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.IntPredicate;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.index.BatchingMultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxyFactory;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.NodePropertyUpdates;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;

public class BatchingMultipleIndexPopulatorTest {
    @After
    public void tearDown() throws Exception {
        BatchingMultipleIndexPopulatorTest.clearProperty("queue_threshold");
        BatchingMultipleIndexPopulatorTest.clearProperty("task_queue_size");
        BatchingMultipleIndexPopulatorTest.clearProperty("await_timeout_minutes");
        BatchingMultipleIndexPopulatorTest.clearProperty("batch_size");
    }

    @Test
    public void populateFromQueueDoesNothingIfThresholdNotReached() throws Exception {
        BatchingMultipleIndexPopulatorTest.setProperty("queue_threshold", 5);
        BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator((IndexStoreView)Mockito.mock(IndexStoreView.class), (ExecutorService)Mockito.mock(ExecutorService.class), (LogProvider)NullLogProvider.getInstance());
        IndexPopulator populator = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, 1);
        IndexUpdater updater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)populator.newPopulatingUpdater((PropertyAccessor)Matchers.any())).thenReturn((Object)updater);
        NodePropertyUpdate update1 = NodePropertyUpdate.add((long)1L, (int)1, (Object)"foo", (long[])new long[]{1L});
        NodePropertyUpdate update2 = NodePropertyUpdate.add((long)2L, (int)1, (Object)"bar", (long[])new long[]{1L});
        batchingPopulator.queue(update1);
        batchingPopulator.queue(update2);
        batchingPopulator.populateFromQueueBatched(42L);
        ((IndexUpdater)Mockito.verify((Object)updater, (VerificationMode)Mockito.never())).process((NodePropertyUpdate)Matchers.any());
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.never())).newPopulatingUpdater((PropertyAccessor)Matchers.any());
    }

    @Test
    public void populateFromQueuePopulatesWhenThresholdReached() throws Exception {
        BatchingMultipleIndexPopulatorTest.setProperty("queue_threshold", 2);
        NeoStores neoStores = (NeoStores)Mockito.mock(NeoStores.class);
        NodeStore nodeStore = (NodeStore)Mockito.mock(NodeStore.class);
        Mockito.when((Object)neoStores.getNodeStore()).thenReturn((Object)nodeStore);
        NeoStoreIndexStoreView storeView = new NeoStoreIndexStoreView(LockService.NO_LOCK_SERVICE, neoStores);
        BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator((IndexStoreView)storeView, (ExecutorService)Mockito.mock(ExecutorService.class), (LogProvider)NullLogProvider.getInstance());
        IndexPopulator populator1 = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, 1);
        IndexUpdater updater1 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)populator1.newPopulatingUpdater((PropertyAccessor)Matchers.any())).thenReturn((Object)updater1);
        IndexPopulator populator2 = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, 2);
        IndexUpdater updater2 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)populator2.newPopulatingUpdater((PropertyAccessor)Matchers.any())).thenReturn((Object)updater2);
        batchingPopulator.indexAllNodes();
        NodePropertyUpdate update1 = NodePropertyUpdate.add((long)1L, (int)1, (Object)"foo", (long[])new long[]{1L});
        NodePropertyUpdate update2 = NodePropertyUpdate.add((long)2L, (int)2, (Object)"bar", (long[])new long[]{2L});
        NodePropertyUpdate update3 = NodePropertyUpdate.add((long)3L, (int)1, (Object)"baz", (long[])new long[]{1L});
        batchingPopulator.queue(update1);
        batchingPopulator.queue(update2);
        batchingPopulator.queue(update3);
        batchingPopulator.populateFromQueue(42L);
        ((IndexUpdater)Mockito.verify((Object)updater1)).process(update1);
        ((IndexUpdater)Mockito.verify((Object)updater1)).process(update3);
        ((IndexUpdater)Mockito.verify((Object)updater2)).process(update2);
    }

    @Test
    public void executorShutdownAfterStoreScanCompletes() throws Exception {
        NodePropertyUpdate update = NodePropertyUpdate.add((long)1L, (int)1, (Object)"foo", (long[])new long[]{1L});
        IndexStoreView storeView = BatchingMultipleIndexPopulatorTest.newStoreView(update);
        ExecutorService executor = (ExecutorService)Mockito.mock(ExecutorService.class);
        Mockito.when((Object)executor.awaitTermination(Matchers.anyLong(), (TimeUnit)((Object)Matchers.any()))).thenReturn((Object)true);
        BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator(storeView, executor, (LogProvider)NullLogProvider.getInstance());
        StoreScan storeScan = batchingPopulator.indexAllNodes();
        ((ExecutorService)Mockito.verify((Object)executor, (VerificationMode)Mockito.never())).shutdown();
        storeScan.run();
        ((ExecutorService)Mockito.verify((Object)executor)).shutdown();
        ((ExecutorService)Mockito.verify((Object)executor)).awaitTermination(Matchers.anyLong(), (TimeUnit)((Object)Matchers.any()));
    }

    @Test
    public void executorForcefullyShutdownIfStoreScanFails() throws Exception {
        IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
        StoreScan failingStoreScan = (StoreScan)Mockito.mock(StoreScan.class);
        RuntimeException scanError = new RuntimeException();
        ((StoreScan)Mockito.doThrow((Throwable)scanError).when((Object)failingStoreScan)).run();
        Mockito.when((Object)storeView.visitNodes((int[])Matchers.any(), (IntPredicate)Matchers.any(), (Visitor)Matchers.any(), (Visitor)Matchers.any())).thenReturn((Object)failingStoreScan);
        ExecutorService executor = (ExecutorService)Mockito.mock(ExecutorService.class);
        Mockito.when((Object)executor.awaitTermination(Matchers.anyLong(), (TimeUnit)((Object)Matchers.any()))).thenReturn((Object)true);
        BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator(storeView, executor, (LogProvider)NullLogProvider.getInstance());
        StoreScan storeScan = batchingPopulator.indexAllNodes();
        ((ExecutorService)Mockito.verify((Object)executor, (VerificationMode)Mockito.never())).shutdown();
        try {
            storeScan.run();
            Assert.fail((String)"Exception expected");
        }
        catch (Throwable t) {
            Assert.assertSame((Object)scanError, (Object)t);
        }
        ((ExecutorService)Mockito.verify((Object)executor)).shutdownNow();
        ((ExecutorService)Mockito.verify((Object)executor)).awaitTermination(Matchers.anyLong(), (TimeUnit)((Object)Matchers.any()));
    }

    @Test
    public void pendingBatchesFlushedAfterStoreScan() throws Exception {
        NodePropertyUpdate update1 = NodePropertyUpdate.add((long)1L, (int)1, (Object)"foo", (long[])new long[]{1L});
        NodePropertyUpdate update2 = NodePropertyUpdate.add((long)2L, (int)1, (Object)"bar", (long[])new long[]{1L});
        NodePropertyUpdate update3 = NodePropertyUpdate.add((long)3L, (int)1, (Object)"baz", (long[])new long[]{1L});
        NodePropertyUpdate update42 = NodePropertyUpdate.add((long)4L, (int)42, (Object)"42", (long[])new long[]{42L});
        IndexStoreView storeView = BatchingMultipleIndexPopulatorTest.newStoreView(update1, update2, update3, update42);
        BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator(storeView, BatchingMultipleIndexPopulatorTest.sameThreadExecutor(), (LogProvider)NullLogProvider.getInstance());
        IndexPopulator populator1 = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, 1);
        IndexPopulator populator42 = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, 42);
        batchingPopulator.indexAllNodes().run();
        ((IndexPopulator)Mockito.verify((Object)populator1)).add(Arrays.asList(update1, update2, update3));
        ((IndexPopulator)Mockito.verify((Object)populator42)).add(Collections.singletonList(update42));
    }

    @Test
    public void batchIsFlushedWhenThresholdReached() throws Exception {
        BatchingMultipleIndexPopulatorTest.setProperty("batch_size", 2);
        NodePropertyUpdate update1 = NodePropertyUpdate.add((long)1L, (int)1, (Object)"foo", (long[])new long[]{1L});
        NodePropertyUpdate update2 = NodePropertyUpdate.add((long)2L, (int)1, (Object)"bar", (long[])new long[]{1L});
        NodePropertyUpdate update3 = NodePropertyUpdate.add((long)3L, (int)1, (Object)"baz", (long[])new long[]{1L});
        IndexStoreView storeView = BatchingMultipleIndexPopulatorTest.newStoreView(update1, update2, update3);
        BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator(storeView, BatchingMultipleIndexPopulatorTest.sameThreadExecutor(), (LogProvider)NullLogProvider.getInstance());
        IndexPopulator populator = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, 1);
        batchingPopulator.indexAllNodes().run();
        ((IndexPopulator)Mockito.verify((Object)populator)).add(Arrays.asList(update1, update2));
        ((IndexPopulator)Mockito.verify((Object)populator)).add(Collections.singletonList(update3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void populatorMarkedAsFailed() throws Exception {
        IndexPopulator populator;
        BatchingMultipleIndexPopulatorTest.setProperty("batch_size", 2);
        NodePropertyUpdate update1 = NodePropertyUpdate.add((long)1L, (int)1, (Object)"aaa", (long[])new long[]{1L});
        NodePropertyUpdate update2 = NodePropertyUpdate.add((long)1L, (int)1, (Object)"bbb", (long[])new long[]{1L});
        IndexStoreView storeView = BatchingMultipleIndexPopulatorTest.newStoreView(update1, update2);
        RuntimeException batchFlushError = new RuntimeException("Batch failed");
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator(storeView, executor, (LogProvider)NullLogProvider.getInstance());
            populator = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, 1);
            ((IndexPopulator)Mockito.doThrow((Throwable)batchFlushError).when((Object)populator)).add(Arrays.asList(update1, update2));
            batchingPopulator.indexAllNodes().run();
        }
        finally {
            executor.shutdown();
            executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        ((IndexPopulator)Mockito.verify((Object)populator)).markAsFailed(IndexPopulationFailure.failure((Throwable)batchFlushError).asString());
    }

    @Test
    public void populatorMarkedAsFailedAndUpdatesNotAdded() throws Exception {
        BatchingMultipleIndexPopulatorTest.setProperty("batch_size", 2);
        NodePropertyUpdate update1 = NodePropertyUpdate.add((long)1L, (int)1, (Object)"aaa", (long[])new long[]{1L});
        NodePropertyUpdate update2 = NodePropertyUpdate.add((long)1L, (int)1, (Object)"bbb", (long[])new long[]{1L});
        NodePropertyUpdate update3 = NodePropertyUpdate.add((long)1L, (int)1, (Object)"ccc", (long[])new long[]{1L});
        NodePropertyUpdate update4 = NodePropertyUpdate.add((long)1L, (int)1, (Object)"ddd", (long[])new long[]{1L});
        NodePropertyUpdate update5 = NodePropertyUpdate.add((long)1L, (int)1, (Object)"eee", (long[])new long[]{1L});
        IndexStoreView storeView = BatchingMultipleIndexPopulatorTest.newStoreView(update1, update2, update3, update4, update5);
        RuntimeException batchFlushError = new RuntimeException("Batch failed");
        BatchingMultipleIndexPopulator batchingPopulator = new BatchingMultipleIndexPopulator(storeView, BatchingMultipleIndexPopulatorTest.sameThreadExecutor(), (LogProvider)NullLogProvider.getInstance());
        IndexPopulator populator = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, 1);
        ((IndexPopulator)Mockito.doThrow((Throwable)batchFlushError).when((Object)populator)).add(Arrays.asList(update3, update4));
        batchingPopulator.indexAllNodes().run();
        ((IndexPopulator)Mockito.verify((Object)populator)).add(Arrays.asList(update1, update2));
        ((IndexPopulator)Mockito.verify((Object)populator)).add(Arrays.asList(update3, update4));
        ((IndexPopulator)Mockito.verify((Object)populator)).markAsFailed(IndexPopulationFailure.failure((Throwable)batchFlushError).asString());
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.never())).add(Collections.singletonList(update5));
    }

    private static IndexPopulator addPopulator(BatchingMultipleIndexPopulator batchingPopulator, int id) {
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        IndexDescriptor descriptor = new IndexDescriptor(id, id);
        IndexProxyFactory indexProxyFactory = (IndexProxyFactory)Mockito.mock(IndexProxyFactory.class);
        FailedIndexProxyFactory failedIndexProxyFactory = (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class);
        FlippableIndexProxy flipper = new FlippableIndexProxy();
        flipper.setFlipTarget(indexProxyFactory);
        batchingPopulator.addPopulator(populator, descriptor, new SchemaIndexProvider.Descriptor("foo", "1"), IndexConfiguration.NON_UNIQUE, flipper, failedIndexProxyFactory, "testIndex");
        return populator;
    }

    private static IndexStoreView newStoreView(NodePropertyUpdate ... updates) {
        IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
        Mockito.when((Object)storeView.visitNodes((int[])Matchers.any(), (IntPredicate)Matchers.any(), (Visitor)Matchers.any(), (Visitor)Matchers.any())).thenAnswer(invocation -> {
            Object visitorArg = invocation.getArguments()[2];
            Visitor visitor = (Visitor)visitorArg;
            return new NodePropertyUpdatesScan(updates, (Visitor<NodePropertyUpdates, IndexPopulationFailedKernelException>)visitor);
        });
        return storeView;
    }

    private static ExecutorService sameThreadExecutor() throws InterruptedException {
        ExecutorService executor = (ExecutorService)Mockito.mock(ExecutorService.class);
        Mockito.when((Object)executor.awaitTermination(Matchers.anyLong(), (TimeUnit)((Object)Matchers.any()))).thenReturn((Object)true);
        ((ExecutorService)Mockito.doAnswer(invocation -> {
            ((Runnable)invocation.getArguments()[0]).run();
            return null;
        }).when((Object)executor)).execute((Runnable)Matchers.any());
        return executor;
    }

    private static void setProperty(String name, int value) {
        FeatureToggles.set(BatchingMultipleIndexPopulator.class, (String)name, (Object)value);
    }

    private static void clearProperty(String name) {
        FeatureToggles.clear(BatchingMultipleIndexPopulator.class, (String)name);
    }

    private static class NodePropertyUpdatesScan
    implements StoreScan<IndexPopulationFailedKernelException> {
        final NodePropertyUpdate[] updates;
        final Visitor<NodePropertyUpdates, IndexPopulationFailedKernelException> visitor;
        boolean stop;

        NodePropertyUpdatesScan(NodePropertyUpdate[] updates, Visitor<NodePropertyUpdates, IndexPopulationFailedKernelException> visitor) {
            this.updates = updates;
            this.visitor = visitor;
        }

        public void run() throws IndexPopulationFailedKernelException {
            NodePropertyUpdates nodePropertyUpdates = new NodePropertyUpdates();
            for (NodePropertyUpdate update : this.updates) {
                if (this.stop) {
                    return;
                }
                nodePropertyUpdates.initForNodeId(update.getNodeId());
                nodePropertyUpdates.add(update);
                this.visitor.visit((Object)nodePropertyUpdates);
                nodePropertyUpdates.reset();
            }
        }

        public void stop() {
            this.stop = true;
        }

        public void acceptUpdate(MultipleIndexPopulator.MultipleIndexUpdater updater, NodePropertyUpdate update, long currentlyIndexedNodeId) {
        }

        public PopulationProgress getProgress() {
            return PopulationProgress.NONE;
        }

        public void configure(List<MultipleIndexPopulator.IndexPopulation> populations) {
        }
    }
}

