/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.kernel.api.ExecutingQuery;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.SecurityContext;

public class TestKernelTransactionHandle
implements KernelTransactionHandle {
    private final KernelTransaction tx;

    public TestKernelTransactionHandle(KernelTransaction tx) {
        this.tx = Objects.requireNonNull(tx);
    }

    public long lastTransactionIdWhenStarted() {
        return this.tx.lastTransactionIdWhenStarted();
    }

    public long lastTransactionTimestampWhenStarted() {
        return this.tx.lastTransactionTimestampWhenStarted();
    }

    public long startTime() {
        return this.tx.startTime();
    }

    public boolean isOpen() {
        return this.tx.isOpen();
    }

    public boolean markForTermination(Status reason) {
        this.tx.markForTermination(reason);
        return true;
    }

    public SecurityContext securityContext() {
        return this.tx.securityContext();
    }

    public Optional<Status> terminationReason() {
        return Optional.ofNullable(this.tx.getReasonIfTerminated());
    }

    public boolean isUnderlyingTransaction(KernelTransaction tx) {
        return this.tx == tx;
    }

    public Stream<ExecutingQuery> executingQueries() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestKernelTransactionHandle that = (TestKernelTransactionHandle)o;
        return this.tx.equals(that.tx);
    }

    public int hashCode() {
        return this.tx.hashCode();
    }

    public String toString() {
        return "TestKernelTransactionHandle{tx=" + this.tx + "}";
    }
}

