/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.api.BatchTransactionApplier;
import org.neo4j.kernel.impl.api.BatchTransactionApplierFacade;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.api.TransactionApplierFacade;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.storageengine.api.CommandsToApply;

public class BatchTransactionApplierFacadeTest {
    private BatchTransactionApplierFacade facade;
    private BatchTransactionApplier applier1;
    private BatchTransactionApplier applier2;
    private BatchTransactionApplier applier3;
    private TransactionApplier txApplier1;
    private TransactionApplier txApplier2;
    private TransactionApplier txApplier3;

    @Before
    public void setUp() throws Exception {
        this.txApplier1 = (TransactionApplier)Mockito.mock(TransactionApplier.class);
        this.applier1 = (BatchTransactionApplier)Mockito.mock(BatchTransactionApplier.class);
        Mockito.when((Object)this.applier1.startTx((CommandsToApply)Matchers.any(TransactionToApply.class))).thenReturn((Object)this.txApplier1);
        Mockito.when((Object)this.applier1.startTx((CommandsToApply)Matchers.any(TransactionToApply.class), (LockGroup)Matchers.any(LockGroup.class))).thenReturn((Object)this.txApplier1);
        this.txApplier2 = (TransactionApplier)Mockito.mock(TransactionApplier.class);
        this.applier2 = (BatchTransactionApplier)Mockito.mock(BatchTransactionApplier.class);
        Mockito.when((Object)this.applier2.startTx((CommandsToApply)Matchers.any(TransactionToApply.class))).thenReturn((Object)this.txApplier2);
        Mockito.when((Object)this.applier2.startTx((CommandsToApply)Matchers.any(TransactionToApply.class), (LockGroup)Matchers.any(LockGroup.class))).thenReturn((Object)this.txApplier2);
        this.txApplier3 = (TransactionApplier)Mockito.mock(TransactionApplier.class);
        this.applier3 = (BatchTransactionApplier)Mockito.mock(BatchTransactionApplier.class);
        Mockito.when((Object)this.applier3.startTx((CommandsToApply)Matchers.any(TransactionToApply.class))).thenReturn((Object)this.txApplier3);
        Mockito.when((Object)this.applier3.startTx((CommandsToApply)Matchers.any(TransactionToApply.class), (LockGroup)Matchers.any(LockGroup.class))).thenReturn((Object)this.txApplier3);
        this.facade = new BatchTransactionApplierFacade(new BatchTransactionApplier[]{this.applier1, this.applier2, this.applier3});
    }

    @Test
    public void testStartTxCorrectOrder() throws Exception {
        TransactionToApply tx = (TransactionToApply)Mockito.mock(TransactionToApply.class);
        TransactionApplierFacade result = (TransactionApplierFacade)this.facade.startTx((CommandsToApply)tx);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.applier1, this.applier2, this.applier3});
        ((BatchTransactionApplier)inOrder.verify((Object)this.applier1)).startTx((CommandsToApply)tx);
        ((BatchTransactionApplier)inOrder.verify((Object)this.applier2)).startTx((CommandsToApply)tx);
        ((BatchTransactionApplier)inOrder.verify((Object)this.applier3)).startTx((CommandsToApply)tx);
        Assert.assertEquals((Object)this.txApplier1, (Object)result.appliers[0]);
        Assert.assertEquals((Object)this.txApplier2, (Object)result.appliers[1]);
        Assert.assertEquals((Object)this.txApplier3, (Object)result.appliers[2]);
        Assert.assertEquals((long)3L, (long)result.appliers.length);
    }

    @Test
    public void testStartTxCorrectOrderWithLockGroup() throws Exception {
        TransactionToApply tx = (TransactionToApply)Mockito.mock(TransactionToApply.class);
        LockGroup lockGroup = (LockGroup)Mockito.mock(LockGroup.class);
        TransactionApplierFacade result = (TransactionApplierFacade)this.facade.startTx((CommandsToApply)tx, lockGroup);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.applier1, this.applier2, this.applier3});
        ((BatchTransactionApplier)inOrder.verify((Object)this.applier1)).startTx((CommandsToApply)tx, lockGroup);
        ((BatchTransactionApplier)inOrder.verify((Object)this.applier2)).startTx((CommandsToApply)tx, lockGroup);
        ((BatchTransactionApplier)inOrder.verify((Object)this.applier3)).startTx((CommandsToApply)tx, lockGroup);
        Assert.assertEquals((Object)this.txApplier1, (Object)result.appliers[0]);
        Assert.assertEquals((Object)this.txApplier2, (Object)result.appliers[1]);
        Assert.assertEquals((Object)this.txApplier3, (Object)result.appliers[2]);
        Assert.assertEquals((long)3L, (long)result.appliers.length);
    }

    @Test
    public void closeShouldBeDoneInReverseOrder() throws Exception {
        this.facade.close();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.applier1, this.applier2, this.applier3});
        ((BatchTransactionApplier)inOrder.verify((Object)this.applier3)).close();
        ((BatchTransactionApplier)inOrder.verify((Object)this.applier2)).close();
        ((BatchTransactionApplier)inOrder.verify((Object)this.applier1)).close();
    }
}

