/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.guard;

import java.time.Clock;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.guard.GuardTimeoutException;
import org.neo4j.kernel.guard.TimeoutGuard;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactionTestBase;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;

public class TimeoutGuardTest
extends KernelTransactionTestBase {
    private AssertableLogProvider logProvider = new AssertableLogProvider(true);

    @Before
    public void setUp() {
        this.logProvider.clear();
    }

    @Test
    public void detectTimedTransaction() {
        long transactionTimeout = 10L;
        long overtime = 1L;
        TimeoutGuard timeoutGuard = this.buildGuard(this.logProvider);
        this.initClock();
        KernelStatement kernelStatement = this.getKernelStatement(transactionTimeout);
        this.clock.forward(transactionTimeout + overtime, TimeUnit.MILLISECONDS);
        String message = "Transaction timeout. (Overtime: 1 ms).";
        this.check(timeoutGuard, kernelStatement, overtime, message);
        KernelTransactionImplementation transaction = kernelStatement.getTransaction();
        Assert.assertSame((Object)Status.Transaction.TransactionTimedOut, (Object)transaction.getReasonIfTerminated());
        this.logProvider.assertContainsMessageContaining(message);
    }

    @Test
    public void allowToProceedWhenTransactionTimeoutNotReached() {
        long transactionTimeout = 100000L;
        long overtime = 5L;
        TimeoutGuard timeoutGuard = this.buildGuard(this.logProvider);
        this.initClock();
        KernelStatement kernelStatement = this.getKernelStatement(transactionTimeout);
        this.clock.forward(overtime, TimeUnit.MILLISECONDS);
        timeoutGuard.check(kernelStatement);
        KernelTransactionImplementation transaction = kernelStatement.getTransaction();
        Assert.assertNull((Object)transaction.getReasonIfTerminated());
        this.logProvider.assertNoLoggingOccurred();
    }

    private void initClock() {
        long startTime = this.getStartTime();
        this.clock.forward(startTime, TimeUnit.MILLISECONDS);
    }

    private void check(TimeoutGuard timeoutGuard, KernelStatement kernelStatement, long overtime, String message) {
        try {
            timeoutGuard.check(kernelStatement);
        }
        catch (GuardTimeoutException e) {
            Assert.assertEquals((String)"Exception should have expected message.", (Object)message, (Object)e.getMessage());
            Assert.assertEquals((String)"Exception should have correct overtime value.", (long)overtime, (long)e.getOvertime());
        }
    }

    private KernelStatement getKernelStatement(long transactionTimeout) {
        KernelTransactionImplementation transaction = this.newNotInitializedTransaction();
        StatementLocks statementLocks = (StatementLocks)Mockito.mock(StatementLocks.class);
        transaction.initialize(1L, 2L, statementLocks, KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED, transactionTimeout);
        return transaction.acquireStatement();
    }

    private TimeoutGuard buildGuard(AssertableLogProvider logProvider) {
        Log log = logProvider.getLog(TimeoutGuard.class);
        return new TimeoutGuard((Clock)this.clock, log);
    }

    private long getStartTime() {
        LocalDateTime startTime = LocalDateTime.of(2016, Month.AUGUST, 17, 15, 10);
        return startTime.toInstant(ZoneOffset.UTC).toEpochMilli();
    }
}

