/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.builtinprocs.IndexSpecifier;

public class IndexSpecifierTest {
    @Test
    public void shouldFormatAsCanonicalRepresentation() {
        MatcherAssert.assertThat((Object)new IndexSpecifier(":Person(name)").toString(), (Matcher)Matchers.is((Object)":Person(name)"));
    }

    @Test
    public void shouldParseASimpleLabel() {
        MatcherAssert.assertThat((Object)new IndexSpecifier(":Person_23(name)").label(), (Matcher)Matchers.is((Object)"Person_23"));
    }

    @Test
    public void shouldParseASimpleProperty() {
        MatcherAssert.assertThat((Object)new IndexSpecifier(":Person(a_Name_123)").property(), (Matcher)Matchers.is((Object)"a_Name_123"));
    }

    @Test
    public void shouldParseANastyLabel() {
        MatcherAssert.assertThat((Object)new IndexSpecifier(":`:(!\"\u00a3$%^&*( )`(name)").label(), (Matcher)Matchers.is((Object)":(!\"\u00a3$%^&*( )"));
    }

    @Test
    public void shouldParseANastyProperty() {
        MatcherAssert.assertThat((Object)new IndexSpecifier(":Person(`(:!\"\u00a3$%^&*( )`)").property(), (Matcher)Matchers.is((Object)"(:!\"\u00a3$%^&*( )"));
    }

    @Test
    public void shouldProduceAReasonableErrorIfTheSpecificationCantBeParsed() {
        try {
            new IndexSpecifier("rubbish");
            Assert.fail((String)"expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

