/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionFactory;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.SchemaWriteOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.storageengine.api.StorageStatement;

public class TransactionStatementSharingTest {
    @Test
    public void shouldShareStatementStateForConcurrentReadStatementAndReadStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction((SecurityContext)AnonymousContext.read());
        ReadOperations stmt1 = tx.acquireStatement().readOperations();
        ReadOperations stmt2 = tx.acquireStatement().readOperations();
        Assert.assertSame((Object)stmt1, (Object)stmt2);
    }

    @Test
    public void shouldShareStatementStateForConcurrentReadStatementAndDataStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction((SecurityContext)AnonymousContext.write());
        ReadOperations stmt1 = tx.acquireStatement().readOperations();
        DataWriteOperations stmt2 = tx.acquireStatement().dataWriteOperations();
        Assert.assertSame((Object)stmt1, (Object)stmt2);
    }

    @Test
    public void shouldShareStatementStateForConcurrentReadStatementAndSchemaStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction(SecurityContext.AUTH_DISABLED);
        ReadOperations stmt1 = tx.acquireStatement().readOperations();
        SchemaWriteOperations stmt2 = tx.acquireStatement().schemaWriteOperations();
        Assert.assertSame((Object)stmt1, (Object)stmt2);
    }

    @Test
    public void shouldShareStatementStateForConcurrentDataStatementAndReadStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction((SecurityContext)AnonymousContext.write());
        DataWriteOperations stmt1 = tx.acquireStatement().dataWriteOperations();
        ReadOperations stmt2 = tx.acquireStatement().readOperations();
        Assert.assertSame((Object)stmt1, (Object)stmt2);
    }

    @Test
    public void shouldShareStatementStateForConcurrentDataStatementAndDataStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction((SecurityContext)AnonymousContext.write());
        DataWriteOperations stmt1 = tx.acquireStatement().dataWriteOperations();
        DataWriteOperations stmt2 = tx.acquireStatement().dataWriteOperations();
        Assert.assertSame((Object)stmt1, (Object)stmt2);
    }

    @Test
    public void shouldShareStatementStateForConcurrentSchemaStatementAndReadStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction(SecurityContext.AUTH_DISABLED);
        SchemaWriteOperations stmt1 = tx.acquireStatement().schemaWriteOperations();
        ReadOperations stmt2 = tx.acquireStatement().readOperations();
        Assert.assertSame((Object)stmt1, (Object)stmt2);
    }

    @Test
    public void shouldShareStatementStateForConcurrentSchemaStatementAndSchemaStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction(SecurityContext.AUTH_DISABLED);
        SchemaWriteOperations stmt1 = tx.acquireStatement().schemaWriteOperations();
        SchemaWriteOperations stmt2 = tx.acquireStatement().schemaWriteOperations();
        Assert.assertSame((Object)stmt1, (Object)stmt2);
    }

    @Test
    public void shouldNotShareStateForSequentialReadStatementAndReadStatement() throws Exception {
        KernelTransactionFactory.Instances instances = KernelTransactionFactory.kernelTransactionWithInternals((SecurityContext)AnonymousContext.read());
        KernelTransactionImplementation tx = instances.transaction;
        Statement statement = tx.acquireStatement();
        ReadOperations ops1 = statement.readOperations();
        ((StorageStatement)Mockito.verify((Object)instances.storageStatement)).acquire();
        statement.close();
        ((StorageStatement)Mockito.verify((Object)instances.storageStatement)).release();
        Mockito.reset((Object[])new StorageStatement[]{instances.storageStatement});
        ReadOperations ops2 = tx.acquireStatement().readOperations();
        ((StorageStatement)Mockito.verify((Object)instances.storageStatement)).acquire();
    }
}

