/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.Exceptions;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.factory.DataSourceModule;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.rule.TestDirectory;

public class GraphDatabaseFacadeFactoryTest {
    @Rule
    public final TestDirectory dir = TestDirectory.testDirectory((FileSystemAbstraction)new EphemeralFileSystemAbstraction());
    private final GraphDatabaseFacade mockFacade = (GraphDatabaseFacade)Mockito.mock(GraphDatabaseFacade.class);
    private final GraphDatabaseFacadeFactory.Dependencies deps = (GraphDatabaseFacadeFactory.Dependencies)Mockito.mock(GraphDatabaseFacadeFactory.Dependencies.class, (Answer)Mockito.RETURNS_MOCKS);

    @Before
    public void setup() {
        Mockito.when((Object)this.deps.monitors()).thenReturn((Object)new Monitors());
    }

    @Test
    public void shouldThrowAppropriateExceptionIfStartFails() {
        RuntimeException startupError = new RuntimeException();
        GraphDatabaseFacadeFactory db = this.newFaultyGraphDatabaseFacadeFactory(startupError);
        try {
            db.initFacade(this.dir.graphDbDir(), Collections.emptyMap(), this.deps, this.mockFacade);
            Assert.fail((String)("Should have thrown " + RuntimeException.class));
        }
        catch (RuntimeException exception) {
            Assert.assertEquals((Object)startupError, (Object)Exceptions.rootCause((Throwable)exception));
        }
    }

    @Test
    public void shouldThrowAppropriateExceptionIfBothStartAndShutdownFail() {
        RuntimeException startupError = new RuntimeException();
        RuntimeException shutdownError = new RuntimeException();
        GraphDatabaseFacadeFactory db = this.newFaultyGraphDatabaseFacadeFactory(startupError);
        ((GraphDatabaseFacade)Mockito.doThrow((Throwable)shutdownError).when((Object)this.mockFacade)).shutdown();
        try {
            db.initFacade(this.dir.graphDbDir(), Collections.emptyMap(), this.deps, this.mockFacade);
            Assert.fail((String)("Should have thrown " + RuntimeException.class));
        }
        catch (RuntimeException exception) {
            Assert.assertEquals((Object)shutdownError, (Object)exception);
            Assert.assertEquals((Object)startupError, (Object)Exceptions.rootCause((Throwable)exception.getSuppressed()[0]));
        }
    }

    private GraphDatabaseFacadeFactory newFaultyGraphDatabaseFacadeFactory(final RuntimeException startupError) {
        return new GraphDatabaseFacadeFactory(DatabaseInfo.UNKNOWN, p -> (EditionModule)Mockito.mock(EditionModule.class, (Answer)Mockito.RETURNS_DEEP_STUBS)){

            protected PlatformModule createPlatform(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade) {
                final LifeSupport lifeMock = (LifeSupport)Mockito.mock(LifeSupport.class);
                ((LifeSupport)Mockito.doThrow((Throwable)startupError).when((Object)lifeMock)).start();
                ((LifeSupport)Mockito.doAnswer(invocation -> invocation.getArguments()[0]).when((Object)lifeMock)).add((Lifecycle)Matchers.any(Lifecycle.class));
                return new PlatformModule(storeDir, params, this.databaseInfo, dependencies, graphDatabaseFacade){

                    public LifeSupport createLife() {
                        return lifeMock;
                    }
                };
            }

            protected DataSourceModule createDataSource(PlatformModule platformModule, EditionModule editionModule, Supplier<QueryExecutionEngine> queryExecutionEngineSupplier) {
                return (DataSourceModule)Mockito.mock(DataSourceModule.class);
            }
        };
    }
}

