/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.neo4j.graphdb.FacadeMethod;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.collection.Iterators;

public class GraphDatabaseServiceFacadeMethods {
    static final FacadeMethod<GraphDatabaseService> CREATE_NODE = new FacadeMethod<GraphDatabaseService>("Node createNode()"){

        @Override
        public void call(GraphDatabaseService graphDatabaseService) {
            graphDatabaseService.createNode();
        }
    };
    static final FacadeMethod<GraphDatabaseService> CREATE_NODE_WITH_LABELS = new FacadeMethod<GraphDatabaseService>("Node createNode( Label... labels )"){

        @Override
        public void call(GraphDatabaseService graphDatabaseService) {
            graphDatabaseService.createNode(new Label[]{Label.label((String)"FOO")});
        }
    };
    static final FacadeMethod<GraphDatabaseService> GET_NODE_BY_ID = new FacadeMethod<GraphDatabaseService>("Node getNodeById( long id )"){

        @Override
        public void call(GraphDatabaseService graphDatabaseService) {
            graphDatabaseService.getNodeById(42L);
        }
    };
    static final FacadeMethod<GraphDatabaseService> GET_RELATIONSHIP_BY_ID = new FacadeMethod<GraphDatabaseService>("Relationship getRelationshipById( long id )"){

        @Override
        public void call(GraphDatabaseService graphDatabaseService) {
            graphDatabaseService.getRelationshipById(87L);
        }
    };
    static final FacadeMethod<GraphDatabaseService> GET_ALL_NODES = new FacadeMethod<GraphDatabaseService>("Iterable<Node> getAllNodes()"){

        @Override
        public void call(GraphDatabaseService graphDatabaseService) {
            for (Node node : graphDatabaseService.getAllNodes()) {
            }
        }
    };
    static final FacadeMethod<GraphDatabaseService> FIND_NODES_BY_LABEL_AND_PROPERTY_DEPRECATED = new FacadeMethod<GraphDatabaseService>("ResourceIterator<Node> findNodeByLabelAndProperty( Label label, String key, Object value )"){

        @Override
        public void call(GraphDatabaseService graphDatabaseService) {
            for (Node node : Iterators.loop((Iterator)graphDatabaseService.findNodes(Label.label((String)"bar"), "baz", (Object)23))) {
            }
        }
    };
    static final FacadeMethod<GraphDatabaseService> FIND_NODES_BY_LABEL = new FacadeMethod<GraphDatabaseService>("ResourceIterator<Node> findNodes( Label label )"){

        @Override
        public void call(GraphDatabaseService graphDatabaseService) {
            for (Node node : Iterators.loop((Iterator)graphDatabaseService.findNodes(Label.label((String)"bar")))) {
            }
        }
    };
    static final FacadeMethod<GraphDatabaseService> GET_ALL_LABELS = new FacadeMethod<GraphDatabaseService>("Iterable<Label> getAllLabels()"){

        @Override
        public void call(GraphDatabaseService graphDatabaseService) {
            graphDatabaseService.getAllLabels();
        }
    };
    static final FacadeMethod<GraphDatabaseService> GET_ALL_LABELS_IN_USE = new FacadeMethod<GraphDatabaseService>("Iterable<Label> getAllLabelsInUse()"){

        @Override
        public void call(GraphDatabaseService graphDatabaseService) {
            graphDatabaseService.getAllLabelsInUse();
        }
    };
    static final FacadeMethod<GraphDatabaseService> GET_ALL_RELATIONSHIP_TYPES = new FacadeMethod<GraphDatabaseService>("Iterable<RelationshipType> getAllRelationshipTypes()"){

        @Override
        public void call(GraphDatabaseService graphDatabaseService) {
            graphDatabaseService.getAllRelationshipTypes();
        }
    };
    static final FacadeMethod<GraphDatabaseService> GET_ALL_RELATIONSHIP_TYPES_IN_USE = new FacadeMethod<GraphDatabaseService>("Iterable<RelationshipType> getAllRelationshipTypesInUse()"){

        @Override
        public void call(GraphDatabaseService graphDatabaseService) {
            graphDatabaseService.getAllRelationshipTypesInUse();
        }
    };
    static final FacadeMethod<GraphDatabaseService> GET_ALL_PROPERTY_KEYS = new FacadeMethod<GraphDatabaseService>("Iterable<String> getAllPropertyKeys()"){

        @Override
        public void call(GraphDatabaseService graphDatabaseService) {
            graphDatabaseService.getAllPropertyKeys();
        }
    };
    static final FacadeMethod<GraphDatabaseService> SCHEMA = new FacadeMethod<GraphDatabaseService>("Schema schema()"){

        @Override
        public void call(GraphDatabaseService graphDatabaseService) {
            graphDatabaseService.schema();
        }
    };
    static final Iterable<FacadeMethod<GraphDatabaseService>> ALL_NON_TRANSACTIONAL_GRAPH_DATABASE_METHODS = Collections.unmodifiableCollection(Arrays.asList(CREATE_NODE, CREATE_NODE_WITH_LABELS, GET_NODE_BY_ID, GET_RELATIONSHIP_BY_ID, GET_ALL_NODES, FIND_NODES_BY_LABEL_AND_PROPERTY_DEPRECATED, FIND_NODES_BY_LABEL, GET_ALL_LABELS, GET_ALL_LABELS_IN_USE, GET_ALL_RELATIONSHIP_TYPES, GET_ALL_RELATIONSHIP_TYPES_IN_USE, GET_ALL_PROPERTY_KEYS, SCHEMA));
}

