/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.util.function.Supplier;
import org.neo4j.common.DependencyResolver;
import org.neo4j.exceptions.UnsatisfiedDependencyException;

public class DependenciesProxy {
    private DependenciesProxy() {
        throw new AssertionError();
    }

    public static <T> T dependencies(DependencyResolver dependencyResolver, Class<T> dependenciesInterface) {
        return dependenciesInterface.cast(Proxy.newProxyInstance(dependenciesInterface.getClassLoader(), new Class[]{dependenciesInterface}, (InvocationHandler)new ProxyHandler(dependencyResolver)));
    }

    private static class ProxyHandler
    implements InvocationHandler {
        private final DependencyResolver dependencyResolver;

        ProxyHandler(DependencyResolver dependencyResolver) {
            this.dependencyResolver = dependencyResolver;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            try {
                if (method.getReturnType().equals(Supplier.class)) {
                    return this.dependencyResolver.provideDependency((Class)((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[0]);
                }
                return this.dependencyResolver.resolveDependency(method.getReturnType());
            }
            catch (IllegalArgumentException e) {
                throw new UnsatisfiedDependencyException((Throwable)e);
            }
        }
    }
}

