/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.reverse;

import java.io.IOException;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.neo4j.io.fs.ReadPastEndException;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatchRepresentation;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.CommittedCommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.UnsupportedLogVersionException;
import org.neo4j.kernel.impl.transaction.log.enveloped.EnvelopeReadChannel;
import org.neo4j.kernel.impl.transaction.log.enveloped.IncompleteEnvelopeReadException;
import org.neo4j.kernel.impl.transaction.log.enveloped.InvalidEndOfFileReadException;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedTransactionCursorMonitor;

public class ReversedEnvelopedCommandBatchCursor
implements CommandBatchCursor {
    private EnvelopeReadChannel currentChannel;
    private final boolean failOnCorruptedLogFiles;
    private final ReversedTransactionCursorMonitor monitor;
    private EnvelopeReadChannel unbridgedChannel;
    private final LogEntryReader logEntryReader;
    private CommandBatchCursor commandBatchCursor;
    private final long logVersion;
    private CommittedCommandBatchRepresentation currentCommandBatch;
    private final LongIterator offsets;

    ReversedEnvelopedCommandBatchCursor(EnvelopeReadChannel channel, LogEntryReader logEntryReader, boolean failOnCorruptedLogFiles, ReversedTransactionCursorMonitor monitor, EnvelopeReadChannel bridgedChannel) throws IOException {
        this.unbridgedChannel = channel;
        this.currentChannel = bridgedChannel;
        this.failOnCorruptedLogFiles = failOnCorruptedLogFiles;
        this.monitor = monitor;
        this.commandBatchCursor = new CommittedCommandBatchCursor((ReadableLogPositionAwareChannel)bridgedChannel, logEntryReader);
        this.logVersion = channel.getLogVersion();
        this.offsets = this.sketchOutEnvelopeStartOffsets();
        this.logEntryReader = logEntryReader;
    }

    private LongIterator sketchOutEnvelopeStartOffsets() throws IOException {
        LongArrayList entryStartPositions;
        block7: {
            entryStartPositions = new LongArrayList(10000);
            try {
                long pos;
                long prevPos = -1L;
                while (prevPos < (pos = this.unbridgedChannel.goToNextEntry())) {
                    entryStartPositions.add(pos);
                    prevPos = pos;
                }
                throw new IOException("Failed to read to end of log file version %d. Last seen byte offset %d".formatted(this.logVersion, pos));
            }
            catch (ReadPastEndException | IncompleteEnvelopeReadException | InvalidEndOfFileReadException prevPos) {
            }
            catch (IOException | RuntimeException e) {
                long[] lArray;
                boolean first = entryStartPositions.isEmpty();
                if (first) {
                    lArray = ArrayUtils.EMPTY_LONG_ARRAY;
                } else {
                    long[] lArray2 = new long[1];
                    lArray = lArray2;
                    lArray2[0] = entryStartPositions.getLast();
                }
                this.monitor.transactionalLogRecordReadFailure(lArray, first ? 0 : 1, this.logVersion);
                if (!this.failOnCorruptedLogFiles) break block7;
                throw e;
            }
        }
        if (this.unbridgedChannel.getLogVersion() != this.logVersion) {
            throw new IllegalArgumentException("The channel which was passed in bridged multiple log versions, it started at version " + this.logVersion + ", but continued through to version " + this.unbridgedChannel.getLogVersion() + ". This isn't supported");
        }
        return entryStartPositions.asReversed().longIterator();
    }

    public boolean next() throws IOException {
        if (!this.offsets.hasNext()) {
            return false;
        }
        if (this.commandBatchCursor.position().getLogVersion() != this.logVersion) {
            this.commandBatchCursor.close();
            this.currentChannel = this.unbridgedChannel;
            this.unbridgedChannel = null;
            this.commandBatchCursor = new CommittedCommandBatchCursor((ReadableLogPositionAwareChannel)this.currentChannel, this.logEntryReader);
        }
        long next = this.offsets.next();
        this.currentChannel.setPositionUnsafe(next);
        try {
            if (!this.commandBatchCursor.next()) {
                return this.next();
            }
        }
        catch (IOException | IllegalStateException | UnsupportedLogVersionException e) {
            this.monitor.transactionalLogRecordReadFailure(new long[]{next}, 1, this.logVersion);
            if (this.failOnCorruptedLogFiles) {
                throw e;
            }
            return this.next();
        }
        this.currentCommandBatch = (CommittedCommandBatchRepresentation)this.commandBatchCursor.get();
        return true;
    }

    public void close() throws IOException {
        this.commandBatchCursor.close();
        if (this.unbridgedChannel != null) {
            this.unbridgedChannel.close();
        }
    }

    public CommittedCommandBatchRepresentation get() {
        return this.currentCommandBatch;
    }

    @Override
    public LogPosition position() {
        return this.commandBatchCursor.position();
    }
}

