/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.neo4j.common.Subject;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.StorageCommand;

public class CompleteCommandBatch
implements CommandBatch {
    private final List<StorageCommand> commands;
    private final long timeStarted;
    private final long latestCommittedTxWhenStarted;
    private final long timeCommitted;
    private final KernelVersion kernelVersion;
    private final Subject subject;
    private final int leaseId;
    private long consensusIndex;
    private long appendIndex = 0L;

    public CompleteCommandBatch(List<StorageCommand> commands, long consensusIndex, long timeStarted, long latestCommittedTxWhenStarted, long timeCommitted, int leaseId, KernelVersion kernelVersion, Subject subject) {
        this.commands = commands;
        this.consensusIndex = consensusIndex;
        this.timeStarted = timeStarted;
        this.latestCommittedTxWhenStarted = latestCommittedTxWhenStarted;
        this.timeCommitted = timeCommitted;
        this.leaseId = leaseId;
        this.kernelVersion = kernelVersion;
        this.subject = subject;
    }

    public void setConsensusIndex(long consensusIndex) {
        this.consensusIndex = consensusIndex;
    }

    public boolean accept(Visitor<StorageCommand, IOException> visitor) throws IOException {
        for (StorageCommand command : this.commands) {
            if (!visitor.visit((Object)command)) continue;
            return true;
        }
        return false;
    }

    public long consensusIndex() {
        return this.consensusIndex;
    }

    public long getTimeStarted() {
        return this.timeStarted;
    }

    public long getLatestCommittedTxWhenStarted() {
        return this.latestCommittedTxWhenStarted;
    }

    public long getTimeCommitted() {
        return this.timeCommitted;
    }

    public int getLeaseId() {
        return this.leaseId;
    }

    public Subject subject() {
        return this.subject;
    }

    public KernelVersion kernelVersion() {
        return this.kernelVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompleteCommandBatch that = (CompleteCommandBatch)o;
        return this.latestCommittedTxWhenStarted == that.latestCommittedTxWhenStarted && this.timeStarted == that.timeStarted && this.consensusIndex == that.consensusIndex && this.appendIndex == that.appendIndex && this.commands.equals(that.commands);
    }

    public int hashCode() {
        int result = this.commands.hashCode();
        result = 31 * result + Long.hashCode(this.consensusIndex);
        result = 31 * result + Long.hashCode(this.appendIndex);
        result = 31 * result + Long.hashCode(this.timeStarted);
        result = 31 * result + Long.hashCode(this.latestCommittedTxWhenStarted);
        return result;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean includeCommands) {
        String basic = String.format("%s[timeStarted:%d, latestCommittedTxWhenStarted:%d, timeCommitted:%d, lease:%d, consensusIndex:%d, commands.length:%d", this.getClass().getSimpleName(), this.timeStarted, this.latestCommittedTxWhenStarted, this.timeCommitted, this.leaseId, this.consensusIndex, this.commands.size());
        if (!includeCommands) {
            return basic;
        }
        StringBuilder builder = new StringBuilder(basic);
        for (StorageCommand command : this.commands) {
            builder.append(String.format("%n%s", command.toString()));
        }
        return builder.toString();
    }

    public boolean isLast() {
        return true;
    }

    public boolean isFirst() {
        return true;
    }

    public boolean isRollback() {
        return false;
    }

    public Iterator<StorageCommand> iterator() {
        return this.commands.iterator();
    }

    public int commandCount() {
        return this.commands.size();
    }

    public long appendIndex() {
        if (this.appendIndex == 0L) {
            throw new IllegalStateException("Append index was not generated for the batch yet.");
        }
        return this.appendIndex;
    }

    public void setAppendIndex(long appendIndex) {
        this.appendIndex = appendIndex;
    }
}

