/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.Writer;
import java.time.Clock;
import org.neo4j.internal.helpers.Format;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.Level;
import org.neo4j.logging.LoggerPrintWriterAdaptor;
import org.neo4j.storageengine.migration.MigrationProgressMonitor;
import org.neo4j.util.VisibleForTesting;

public class VisibleMigrationProgressMonitorFactory {
    static MigrationProgressMonitor forMigration(InternalLog log) {
        return VisibleMigrationProgressMonitorFactory.forMigration(log, Clock.systemUTC());
    }

    @VisibleForTesting
    static MigrationProgressMonitor forMigration(InternalLog log, Clock clock) {
        return new MigrationProgressMonitorImpl(log, clock, "Migrating", "Starting migration of database", "Successfully finished migration of database", "Starting transaction logs migration.", "Transaction logs migration completed.");
    }

    static MigrationProgressMonitor forUpgrade(InternalLog log) {
        return VisibleMigrationProgressMonitorFactory.forUpgrade(log, Clock.systemUTC());
    }

    @VisibleForTesting
    static MigrationProgressMonitor forUpgrade(InternalLog log, Clock clock) {
        return new MigrationProgressMonitorImpl(log, clock, "Upgrading", "Starting upgrade of database", "Successfully finished upgrade of database", "Starting transaction logs upgrade.", "Transaction logs upgrade completed.");
    }

    public static MigrationProgressMonitor forSystemUpgrade(InternalLog log) {
        Clock clock = Clock.systemUTC();
        return new MigrationProgressMonitorImpl(log, clock, "Upgrading", "Starting upgrade of system database", "Successfully finished upgrade of system database", "Starting transaction logs upgrade.", "Transaction logs upgrade completed.");
    }

    private static class MigrationProgressMonitorImpl
    implements MigrationProgressMonitor {
        private final InternalLog log;
        private final Clock clock;
        private final String operation;
        private final String messageStarted;
        private final String txLogsUpgradeStarted;
        private final String txLogsUpgradeCompleted;
        private final String messageCompletedWithDuration;
        private int numStages;
        private int currentStage;
        private long startTime;

        MigrationProgressMonitorImpl(InternalLog log, Clock clock, String operation, String messageStarted, String messageCompleted, String txLogsUpgradeStarted, String txLogsUpgradeCompleted) {
            this.log = log;
            this.clock = clock;
            this.operation = operation;
            this.messageStarted = messageStarted;
            this.txLogsUpgradeStarted = txLogsUpgradeStarted;
            this.txLogsUpgradeCompleted = txLogsUpgradeCompleted;
            this.messageCompletedWithDuration = messageCompleted + ", took %s";
        }

        public void started(int numStages) {
            this.numStages = numStages;
            this.log.info(this.messageStarted);
            this.startTime = this.clock.millis();
        }

        public ProgressListener startSection(String name) {
            return this.startSection(name, 100);
        }

        public ProgressListener startSection(String name, int max) {
            this.log.info(String.format("%s %s (%d/%d):", this.operation, name, ++this.currentStage, this.numStages));
            LoggerPrintWriterAdaptor loggerPrintWriterAdaptor = new LoggerPrintWriterAdaptor(this.log, Level.INFO);
            ProgressMonitorFactory progressMonitorFactory = ProgressMonitorFactory.basicTextual((Writer)loggerPrintWriterAdaptor);
            return progressMonitorFactory.singlePart(name, (long)max);
        }

        public void completed() {
            long time = this.clock.millis() - this.startTime;
            this.log.info(this.messageCompletedWithDuration, new Object[]{Format.duration((long)time)});
        }

        public void startTransactionLogsMigration() {
            this.log.info(this.txLogsUpgradeStarted);
        }

        public void completeTransactionLogsMigration() {
            this.log.info(this.txLogsUpgradeCompleted);
        }
    }
}

