/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.schema.IndexOrder;

final class PrimitiveSortedMergeJoin {
    private static final int NOT_INITIALIZED = -1;
    private long nextFromA = -1L;
    private long nextFromB = -1L;
    private int indexOrder;

    PrimitiveSortedMergeJoin() {
    }

    void initialize(IndexOrder indexOrder) {
        this.indexOrder = indexOrder == IndexOrder.DESCENDING ? 1 : -1;
        this.nextFromA = -1L;
        this.nextFromB = -1L;
    }

    boolean needsA() {
        return this.nextFromA == -1L;
    }

    boolean needsB() {
        return this.nextFromB == -1L;
    }

    void setA(long nodeId) {
        this.nextFromA = nodeId;
    }

    void setB(long nodeId) {
        this.nextFromB = nodeId;
    }

    long next() {
        long result;
        long difference = 0L;
        if (this.nextFromA != -1L && this.nextFromB != -1L) {
            difference = Math.subtractExact(this.nextFromA, this.nextFromB);
        }
        if (this.nextFromB == -1L || Long.signum(difference) == this.indexOrder) {
            result = this.nextFromA;
            this.nextFromA = -1L;
        } else {
            result = this.nextFromB;
            this.nextFromB = -1L;
        }
        return result;
    }
}

