/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;

class ReadableChannelPageCursor
extends PageCursor {
    private final ReadableChannel channel;
    private CursorException cursorException;

    ReadableChannelPageCursor(ReadableChannel channel) {
        this.channel = channel;
    }

    public byte getByte() {
        try {
            return this.channel.get();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public byte getByte(int offset) {
        throw new UnsupportedOperationException();
    }

    public void putByte(byte value) {
        throw new UnsupportedOperationException();
    }

    public void putByte(int offset, byte value) {
        throw new UnsupportedOperationException();
    }

    public long getLong() {
        try {
            return this.channel.getLong();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public long getLong(int offset) {
        throw new UnsupportedOperationException();
    }

    public void putLong(long value) {
        throw new UnsupportedOperationException();
    }

    public void putLong(int offset, long value) {
        throw new UnsupportedOperationException();
    }

    public int getInt() {
        try {
            return this.channel.getInt();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public int getInt(int offset) {
        throw new UnsupportedOperationException();
    }

    public void putInt(int value) {
        throw new UnsupportedOperationException();
    }

    public void putInt(int offset, int value) {
        throw new UnsupportedOperationException();
    }

    public void getBytes(byte[] data) {
        this.getBytes(data, 0, data.length);
    }

    public void getBytes(byte[] data, int arrayOffset, int length) {
        if (arrayOffset != 0) {
            throw new UnsupportedOperationException();
        }
        try {
            this.channel.get(data, length);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void putBytes(byte[] data) {
        throw new UnsupportedOperationException();
    }

    public void putBytes(byte[] data, int arrayOffset, int length) {
        throw new UnsupportedOperationException();
    }

    public void putBytes(int bytes, byte value) {
        throw new UnsupportedOperationException();
    }

    public short getShort() {
        try {
            return this.channel.getShort();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public short getShort(int offset) {
        throw new UnsupportedOperationException();
    }

    public void putShort(short value) {
        throw new UnsupportedOperationException();
    }

    public void putShort(int offset, short value) {
        throw new UnsupportedOperationException();
    }

    public void setOffset(int offset) {
        throw new UnsupportedOperationException();
    }

    public int getOffset() {
        throw new UnsupportedOperationException();
    }

    public void mark() {
        throw new UnsupportedOperationException();
    }

    public void setOffsetToMark() {
        throw new UnsupportedOperationException();
    }

    public long getCurrentPageId() {
        return 0L;
    }

    public Path getCurrentFile() {
        return null;
    }

    public PagedFile getPagedFile() {
        return null;
    }

    public Path getRawCurrentFile() {
        return null;
    }

    public boolean next() throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean next(long pageId) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void close() {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean shouldRetry() {
        return false;
    }

    public void copyPage(PageCursor targetCursor) {
        throw new UnsupportedOperationException();
    }

    public int copyTo(int sourceOffset, PageCursor targetCursor, int targetOffset, int lengthInBytes) {
        throw new UnsupportedOperationException();
    }

    public int copyTo(int sourceOffset, ByteBuffer targetBuffer) {
        throw new UnsupportedOperationException();
    }

    public int copyFrom(ByteBuffer sourceBuffer, int targetOffset) {
        throw new UnsupportedOperationException();
    }

    public void shiftBytes(int sourceOffset, int length, int shift) {
        throw new UnsupportedOperationException();
    }

    public boolean checkAndClearBoundsFlag() {
        return false;
    }

    public void checkAndClearCursorException() throws CursorException {
        if (this.cursorException != null) {
            try {
                throw this.cursorException;
            }
            catch (Throwable throwable) {
                this.clearCursorException();
                throw throwable;
            }
        }
    }

    public void setCursorException(String message) {
        this.cursorException = new CursorException(message);
    }

    public void clearCursorException() {
        this.cursorException = null;
    }

    public PageCursor openLinkedCursor(long pageId) {
        throw new UnsupportedOperationException();
    }

    public void zapPage() {
        throw new UnsupportedOperationException();
    }

    public boolean isWriteLocked() {
        return false;
    }

    public void setPageHorizon(long horizon) {
        throw new UnsupportedOperationException();
    }

    public void unpin() {
    }

    public ByteOrder getByteOrder() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

