/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.AbstractArrayType;
import org.neo4j.kernel.impl.index.schema.BooleanArrayType;
import org.neo4j.kernel.impl.index.schema.BooleanType;
import org.neo4j.kernel.impl.index.schema.DateArrayType;
import org.neo4j.kernel.impl.index.schema.DateType;
import org.neo4j.kernel.impl.index.schema.DurationArrayType;
import org.neo4j.kernel.impl.index.schema.DurationType;
import org.neo4j.kernel.impl.index.schema.LocalDateTimeArrayType;
import org.neo4j.kernel.impl.index.schema.LocalDateTimeType;
import org.neo4j.kernel.impl.index.schema.LocalTimeArrayType;
import org.neo4j.kernel.impl.index.schema.LocalTimeType;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NumberArrayType;
import org.neo4j.kernel.impl.index.schema.NumberType;
import org.neo4j.kernel.impl.index.schema.TextArrayType;
import org.neo4j.kernel.impl.index.schema.TextType;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.kernel.impl.index.schema.Types;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeArrayType;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeType;
import org.neo4j.kernel.impl.index.schema.ZonedTimeArrayType;
import org.neo4j.kernel.impl.index.schema.ZonedTimeType;
import org.neo4j.string.UTF8;
import org.neo4j.values.storable.PrimitiveArrayWriting;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeZones;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;

public abstract class GenericKey<KEY extends GenericKey<KEY>>
extends NativeIndexKey<KEY> {
    public static final int TYPE_ID_SIZE = 1;
    static final int BIGGEST_STATIC_SIZE = 32;
    static final long TRUE = 1L;
    static final long FALSE = 0L;
    static final long AVG_MONTH_SECONDS = 2629800L;
    static final long AVG_DAY_SECONDS = 86400L;
    Type type;
    NativeIndexKey.Inclusion inclusion;
    boolean isArray;
    long long0;
    long long1;
    long long2;
    long long3;
    byte[] byteArray;
    long[] long0Array;
    long[] long1Array;
    long[] long2Array;
    long[] long3Array;
    byte[][] byteArrayArray;
    boolean isHighestArray;
    int arrayLength;
    int currentArrayOffset;
    SpaceFillingCurve spaceFillingCurve;

    abstract KEY stateSlot(int var1);

    abstract Type[] getTypesById();

    abstract AbstractArrayType<?>[] getArrayTypes();

    abstract Type getLowestByValueGroup();

    abstract Type getHighestByValueGroup();

    abstract Type[] getTypesByGroup();

    void clear() {
        if (this.type == Types.TEXT && Type.booleanOf(this.long1)) {
            this.byteArray = null;
        }
        this.type = null;
        this.long0 = 0L;
        this.long1 = 0L;
        this.long2 = 0L;
        this.long3 = 0L;
        this.inclusion = NativeIndexKey.Inclusion.NEUTRAL;
        this.isArray = false;
        this.arrayLength = 0;
        this.isHighestArray = false;
        this.currentArrayOffset = 0;
        this.spaceFillingCurve = null;
    }

    void initializeToDummyValue() {
        this.setEntityId(Long.MIN_VALUE);
        this.initializeToDummyValueInternal();
    }

    void initializeToDummyValueInternal() {
        this.clear();
        this.writeInteger(0);
        this.inclusion = NativeIndexKey.Inclusion.NEUTRAL;
    }

    void initValueAsLowest(ValueGroup valueGroup) {
        this.clear();
        this.type = valueGroup == ValueGroup.UNKNOWN || valueGroup == ValueGroup.ANYTHING ? this.getLowestByValueGroup() : this.getTypesByGroup()[valueGroup.ordinal()];
        this.type.initializeAsLowest(this);
    }

    void initValueAsHighest(ValueGroup valueGroup) {
        this.clear();
        this.type = valueGroup == ValueGroup.UNKNOWN || valueGroup == ValueGroup.ANYTHING ? this.getHighestByValueGroup() : this.getTypesByGroup()[valueGroup.ordinal()];
        this.type.initializeAsHighest(this);
    }

    void initAsPrefixLow(TextValue prefix) {
        prefix.writeTo((ValueWriter)this);
        this.long2 = 0L;
        this.inclusion = NativeIndexKey.Inclusion.LOW;
    }

    void initAsPrefixHigh(TextValue prefix) {
        prefix.writeTo((ValueWriter)this);
        this.long2 = 1L;
        this.inclusion = NativeIndexKey.Inclusion.HIGH;
    }

    void copyFrom(GenericKey<?> key) {
        this.setEntityId(key.getEntityId());
        this.setCompareId(key.getCompareId());
        this.copyFromInternal(key);
    }

    void copyFromInternal(GenericKey<?> key) {
        this.copyMetaFrom(key);
        this.type.copyValue(this, key);
    }

    void copyMetaFrom(GenericKey<?> key) {
        this.type = key.type;
        this.inclusion = key.inclusion;
        this.isArray = key.isArray;
        if (key.isArray) {
            this.arrayLength = key.arrayLength;
            this.currentArrayOffset = key.currentArrayOffset;
            this.isHighestArray = key.isHighestArray;
        }
    }

    void writeValue(Value value, NativeIndexKey.Inclusion inclusion) {
        this.isArray = false;
        value.writeTo((ValueWriter)this);
        this.inclusion = inclusion;
    }

    @Override
    void writeValue(int stateSlot, Value value, NativeIndexKey.Inclusion inclusion) {
        this.writeValue(value, inclusion);
    }

    @Override
    void assertValidValue(int stateSlot, Value value) {
    }

    @Override
    Value[] asValues() {
        return new Value[]{this.asValue()};
    }

    @Override
    void initValueAsLowest(int stateSlot, ValueGroup valueGroup) {
        this.initValueAsLowest(valueGroup);
    }

    @Override
    void initValueAsHighest(int stateSlot, ValueGroup valueGroup) {
        this.initValueAsHighest(valueGroup);
    }

    static void setCursorException(PageCursor cursor, String reason) {
        cursor.setCursorException("Unable to read generic key slot due to " + reason);
    }

    @Override
    int numberOfStateSlots() {
        return 1;
    }

    @Override
    int compareValueTo(KEY other) {
        return this.compareValueToInternal(other);
    }

    int compareValueToInternal(KEY other) {
        if (this.type != ((GenericKey)((Object)other)).type) {
            if (this.type == null) {
                return -1;
            }
            if (((GenericKey)((Object)other)).type == null) {
                return 1;
            }
            return Type.COMPARATOR.compare(this.type, ((GenericKey)((Object)other)).type);
        }
        int valueComparison = this.type.compareValue(this, (GenericKey<?>)((Object)other));
        if (valueComparison != 0) {
            return valueComparison;
        }
        return this.inclusion.compareTo(((GenericKey)((Object)other)).inclusion);
    }

    void minimalSplitter(KEY left, KEY right, KEY into) {
        ((NativeIndexKey)((Object)into)).setCompareId(((NativeIndexKey)((Object)right)).getCompareId());
        if (((GenericKey)((Object)left)).compareValueTo(right) != 0) {
            ((NativeIndexKey)((Object)into)).setEntityId(-1L);
        } else {
            ((NativeIndexKey)((Object)into)).setEntityId(((NativeIndexKey)((Object)right)).getEntityId());
        }
        this.minimalSplitterInternal(left, right, into);
    }

    void minimalSplitterInternal(KEY left, KEY right, KEY into) {
        ((GenericKey)((Object)into)).clear();
        ((GenericKey)((Object)into)).copyMetaFrom((GenericKey<?>)((Object)right));
        ((GenericKey)((Object)right)).type.minimalSplitter((GenericKey<?>)((Object)left), (GenericKey<?>)((Object)right), (GenericKey<?>)((Object)into));
    }

    int size() {
        return 8 + this.sizeInternal();
    }

    int sizeInternal() {
        return this.type.valueSize(this) + 1;
    }

    Value asValue() {
        return this.type.asValue(this);
    }

    void put(PageCursor cursor) {
        cursor.putLong(this.getEntityId());
        this.putInternal(cursor);
    }

    void putInternal(PageCursor cursor) {
        cursor.putByte(this.type.typeId);
        this.type.putValue(cursor, this);
    }

    boolean get(PageCursor cursor, int size) {
        if (size < 8) {
            this.initializeToDummyValue();
            cursor.setCursorException("Failed to read GenericKey due to keySize < ENTITY_ID_SIZE");
            return false;
        }
        this.initialize(cursor.getLong());
        if (!this.getInternal(cursor, size)) {
            this.initializeToDummyValue();
            return false;
        }
        return true;
    }

    boolean getInternal(PageCursor cursor, int size) {
        if (size <= 1) {
            GenericKey.setCursorException(cursor, "slot size less than TYPE_ID_SIZE, " + size);
            return false;
        }
        byte typeId = cursor.getByte();
        if (typeId < 0 || typeId >= this.getTypesById().length) {
            GenericKey.setCursorException(cursor, "non-valid typeId, " + typeId);
            return false;
        }
        this.inclusion = NativeIndexKey.Inclusion.NEUTRAL;
        return this.setType(this.getTypesById()[typeId]).readValue(cursor, size - 1, this);
    }

    protected <T extends Type> T setType(T type) {
        if (this.type != null && type != this.type) {
            this.clear();
        }
        this.type = type;
        return type;
    }

    protected void writeDate(long epochDay) {
        if (!this.isArray) {
            this.setType(Types.DATE);
            DateType.write(this, epochDay);
        } else {
            DateArrayType.write(this, this.currentArrayOffset++, epochDay);
        }
    }

    protected void writeLocalTime(long nanoOfDay) {
        if (!this.isArray) {
            this.setType(Types.LOCAL_TIME);
            LocalTimeType.write(this, nanoOfDay);
        } else {
            LocalTimeArrayType.write(this, this.currentArrayOffset++, nanoOfDay);
        }
    }

    protected void writeTime(long nanosOfDayUTC, int offsetSeconds) {
        if (!this.isArray) {
            this.setType(Types.ZONED_TIME);
            ZonedTimeType.write(this, nanosOfDayUTC, offsetSeconds);
        } else {
            ZonedTimeArrayType.write(this, this.currentArrayOffset++, nanosOfDayUTC, offsetSeconds);
        }
    }

    protected void writeLocalDateTime(long epochSecond, int nano) {
        if (!this.isArray) {
            this.setType(Types.LOCAL_DATE_TIME);
            LocalDateTimeType.write(this, epochSecond, nano);
        } else {
            LocalDateTimeArrayType.write(this, this.currentArrayOffset++, epochSecond, nano);
        }
    }

    protected void writeDateTime(long epochSecondUTC, int nano, int offsetSeconds) {
        this.writeDateTime(epochSecondUTC, nano, (short)-1, offsetSeconds);
    }

    protected void writeDateTime(long epochSecondUTC, int nano, String zoneId) {
        this.writeDateTime(epochSecondUTC, nano, TimeZones.map((String)zoneId));
    }

    protected void writeDateTime(long epochSecondUTC, int nano, short zoneId) {
        this.writeDateTime(epochSecondUTC, nano, zoneId, 0);
    }

    private void writeDateTime(long epochSecondUTC, int nano, short zoneId, int offsetSeconds) {
        if (!this.isArray) {
            this.setType(Types.ZONED_DATE_TIME);
            ZonedDateTimeType.write(this, epochSecondUTC, nano, zoneId, offsetSeconds);
        } else {
            ZonedDateTimeArrayType.write(this, this.currentArrayOffset++, epochSecondUTC, nano, zoneId, offsetSeconds);
        }
    }

    public void writeBoolean(boolean value) {
        if (!this.isArray) {
            this.setType(Types.BOOLEAN);
            BooleanType.write(this, value);
        } else {
            BooleanArrayType.write(this, this.currentArrayOffset++, value);
        }
    }

    private void writeNumber(long value, byte numberType) {
        if (!this.isArray) {
            this.setType(Types.NUMBER);
            NumberType.write(this, value, numberType);
        } else {
            NumberArrayType.write(this, this.currentArrayOffset++, value);
        }
    }

    public void writeInteger(byte value) {
        this.writeNumber(value, (byte)0);
    }

    public void writeInteger(short value) {
        this.writeNumber(value, (byte)1);
    }

    public void writeInteger(int value) {
        this.writeNumber(value, (byte)2);
    }

    public void writeInteger(long value) {
        this.writeNumber(value, (byte)3);
    }

    public void writeFloatingPoint(float value) {
        this.writeNumber(Float.floatToIntBits(value), (byte)4);
    }

    public void writeFloatingPoint(double value) {
        this.writeNumber(Double.doubleToLongBits(value), (byte)5);
    }

    public void writeString(String value) {
        this.writeStringBytes(UTF8.encode((String)value), false);
    }

    public void writeString(char value) {
        this.writeStringBytes(UTF8.encode((String)String.valueOf(value)), true);
    }

    public void writeUTF8(byte[] bytes, int offset, int length) {
        byte[] dest = new byte[length];
        System.arraycopy(bytes, offset, dest, 0, length);
        this.writeStringBytes(dest, false);
    }

    private void writeStringBytes(byte[] bytes, boolean isCharType) {
        if (!this.isArray) {
            this.setType(Types.TEXT);
            TextType.write(this, bytes, isCharType);
        } else {
            TextArrayType.write(this, this.currentArrayOffset++, bytes);
        }
        this.long1 = 0L;
    }

    public void writeDuration(long months, long days, long seconds, int nanos) {
        long totalAvgSeconds = months * 2629800L + days * 86400L + seconds;
        this.writeDurationWithTotalAvgSeconds(months, days, totalAvgSeconds, nanos);
    }

    void writeDurationWithTotalAvgSeconds(long months, long days, long totalAvgSeconds, int nanos) {
        if (!this.isArray) {
            this.setType(Types.DURATION);
            DurationType.write(this, months, days, totalAvgSeconds, nanos);
        } else {
            DurationArrayType.write(this, this.currentArrayOffset++, months, days, totalAvgSeconds, nanos);
        }
    }

    public void writeByteArray(byte[] value) {
        PrimitiveArrayWriting.writeTo((ValueWriter)this, (byte[])value);
    }

    public void beginArray(int size, ValueWriter.ArrayType arrayType) {
        AbstractArrayType<?> arrayValueType = this.getArrayTypes()[arrayType.ordinal()];
        this.setType(arrayValueType);
        this.initializeArrayMeta(size);
        arrayValueType.initializeArray(this, size, arrayType);
    }

    void initializeArrayMeta(int size) {
        this.isArray = true;
        this.arrayLength = size;
        this.currentArrayOffset = 0;
    }

    public void endArray() {
    }

    public String toString() {
        return "[" + this.toStringInternal() + "],entityId=" + this.getEntityId();
    }

    String toStringInternal() {
        return this.type == null ? "<null-type>" : this.type.toString(this);
    }

    String toDetailedString() {
        return "[" + this.toDetailedStringInternal() + "],entityId=" + this.getEntityId();
    }

    String toDetailedStringInternal() {
        return this.type.toDetailedString(this);
    }
}

