/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.file.Path;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.AllIndexProviderDescriptors;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProvider;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.impl.index.schema.AbstractIndexProviderFactory;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.token.TokenHolders;

public class FulltextIndexProviderFactory
extends AbstractIndexProviderFactory<FulltextIndexProvider> {
    @Override
    protected Class<?> loggingClass() {
        return FulltextIndexProvider.class;
    }

    @Override
    public IndexProviderDescriptor descriptor() {
        return AllIndexProviderDescriptors.FULLTEXT_DESCRIPTOR;
    }

    @Override
    protected FulltextIndexProvider internalCreate(PageCache pageCache, FileSystemAbstraction fs, Monitors monitors, String monitorTag, Config config, DatabaseReadOnlyChecker readOnlyDatabaseChecker, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, DatabaseLayout databaseLayout, InternalLogProvider logProvider, TokenHolders tokenHolders, JobScheduler scheduler, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, DependencyResolver dependencyResolver) {
        DirectoryFactory directoryFactory = DirectoryFactory.directoryFactory((FileSystemAbstraction)fs);
        IndexDirectoryStructure.Factory directoryStructureFactory = FulltextIndexProviderFactory.subProviderDirectoryStructure(databaseLayout.databaseDirectory());
        return new FulltextIndexProvider(AllIndexProviderDescriptors.FULLTEXT_DESCRIPTOR, directoryStructureFactory, fs, config, tokenHolders, directoryFactory, readOnlyDatabaseChecker, scheduler, logProvider);
    }

    private static IndexDirectoryStructure.Factory subProviderDirectoryStructure(Path storeDir) {
        return IndexDirectoryStructure.directoriesByProvider((Path)storeDir);
    }
}

