/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import java.util.function.Consumer;
import org.neo4j.io.pagecache.PageCursor;

class FailureHeaderWriter
implements Consumer<PageCursor> {
    private static final int HEADER_LENGTH_FIELD_LENGTH = 2;
    private final byte[] failureBytes;
    private final byte byteFailed;

    FailureHeaderWriter(byte[] failureBytes) {
        this(failureBytes, 0);
    }

    FailureHeaderWriter(byte[] failureBytes, byte headerFailureByte) {
        this.failureBytes = failureBytes;
        this.byteFailed = headerFailureByte;
    }

    @Override
    public void accept(PageCursor cursor) {
        byte[] bytesToWrite = this.failureBytes;
        cursor.putByte(this.byteFailed);
        int availableSpace = cursor.getPagedFile().payloadSize() - cursor.getOffset();
        if (bytesToWrite.length + 2 > availableSpace) {
            bytesToWrite = Arrays.copyOf(bytesToWrite, availableSpace - 2);
        }
        cursor.putShort((short)bytesToWrite.length);
        cursor.putBytes(bytesToWrite);
    }
}

