/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Collections;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.neo4j.collection.diffset.IntDiffSets;
import org.neo4j.collection.diffset.MutableIntDiffSets;
import org.neo4j.collection.diffset.TrackableDiffSets;
import org.neo4j.collection.factory.CollectionsFactory;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.api.state.EntityStateImpl;
import org.neo4j.kernel.impl.api.state.RelationshipChangesForNode;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.Degrees;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.RelationshipVisitorWithProperties;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.storageengine.api.txstate.RelationshipModifications;
import org.neo4j.values.storable.Value;

class NodeStateImpl
extends EntityStateImpl
implements NodeState {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(NodeStateImpl.class);
    static final NodeState EMPTY = new NodeState(){

        public Iterable<StorageProperty> addedProperties() {
            return Collections.emptyList();
        }

        public Iterable<StorageProperty> changedProperties() {
            return Collections.emptyList();
        }

        public IntIterable removedProperties() {
            return IntSets.immutable.empty();
        }

        public Iterable<StorageProperty> addedAndChangedProperties() {
            return Collections.emptyList();
        }

        public boolean hasPropertyChanges() {
            return false;
        }

        public IntDiffSets labelDiffSets() {
            return IntDiffSets.EMPTY;
        }

        public boolean fillDegrees(RelationshipSelection selection, Degrees.Mutator degree) {
            return true;
        }

        public long getId() {
            throw new UnsupportedOperationException("id not defined");
        }

        public boolean isPropertyChangedOrRemoved(int propertyKey) {
            return false;
        }

        public boolean isPropertyAdded(int propertyKey) {
            return false;
        }

        public Value propertyValue(int propertyKey) {
            return null;
        }

        public LongIterator getAddedRelationships() {
            return ImmutableEmptyLongIterator.INSTANCE;
        }

        public LongIterator getAddedRelationships(Direction direction) {
            return ImmutableEmptyLongIterator.INSTANCE;
        }

        public LongIterator getAddedRelationships(Direction direction, int relType) {
            return ImmutableEmptyLongIterator.INSTANCE;
        }

        public LongIterator getAddedRelationships(RelationshipDirection direction, int relType) {
            return ImmutableEmptyLongIterator.INSTANCE;
        }

        public IntIterable getAddedRelationshipTypes() {
            return IntSets.immutable.empty();
        }

        public IntIterable getAddedAndRemovedRelationshipTypes() {
            return IntSets.immutable.empty();
        }
    };
    private final boolean addedInThisBatch;
    private MutableIntDiffSets labelDiffSets;
    private RelationshipChangesForNode relationshipsAdded;
    private RelationshipChangesForNode relationshipsRemoved;
    private RelationshipChangesForNode relationshipsUpdated;
    private boolean deleted;

    static NodeStateImpl createNodeState(long id, boolean addedInThisBatch, CollectionsFactory collectionsFactory, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(SHALLOW_SIZE);
        return new NodeStateImpl(id, addedInThisBatch, collectionsFactory, memoryTracker);
    }

    private NodeStateImpl(long id, boolean addedInThisBatch, CollectionsFactory collectionsFactory, MemoryTracker memoryTracker) {
        super(id, collectionsFactory, memoryTracker);
        this.addedInThisBatch = addedInThisBatch;
    }

    public IntDiffSets labelDiffSets() {
        return this.labelDiffSets == null ? IntDiffSets.EMPTY : this.labelDiffSets;
    }

    MutableIntDiffSets getOrCreateLabelDiffSets() {
        if (this.labelDiffSets == null) {
            this.labelDiffSets = TrackableDiffSets.newMutableIntDiffSets((CollectionsFactory)this.collectionsFactory, (MemoryTracker)this.memoryTracker);
        }
        return this.labelDiffSets;
    }

    public void addRelationship(long relId, int typeId, RelationshipDirection direction) {
        if (!this.hasAddedRelationships()) {
            this.relationshipsAdded = RelationshipChangesForNode.createRelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.ADD, this.memoryTracker);
        }
        this.relationshipsAdded.addRelationship(relId, typeId, direction);
    }

    public void removeRelationship(long relId, int typeId, RelationshipDirection direction) {
        if (this.hasAddedRelationships() && this.relationshipsAdded.removeRelationship(relId, typeId, direction)) {
            if (this.relationshipsAdded.isEmpty()) {
                this.relationshipsAdded = null;
            }
            return;
        }
        if (this.hasUpdatedRelationships() && this.relationshipsUpdated.removeRelationship(relId, typeId, direction) && this.relationshipsUpdated.isEmpty()) {
            this.relationshipsUpdated = null;
        }
        if (!this.hasRemovedRelationships()) {
            this.relationshipsRemoved = RelationshipChangesForNode.createRelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.REMOVE, this.memoryTracker);
        }
        this.relationshipsRemoved.addRelationship(relId, typeId, direction);
    }

    public void updateRelationship(long relId, int typeId, RelationshipDirection direction, boolean hasPropertyChanges) {
        if (hasPropertyChanges) {
            if (!this.hasUpdatedRelationships()) {
                this.relationshipsUpdated = RelationshipChangesForNode.createRelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.IGNORE, this.memoryTracker);
            }
            this.relationshipsUpdated.addRelationship(relId, typeId, direction);
        } else if (this.hasUpdatedRelationships() && this.relationshipsUpdated.removeRelationship(relId, typeId, direction) && this.relationshipsUpdated.isEmpty()) {
            this.relationshipsUpdated = null;
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (this.labelDiffSets != null) {
            this.labelDiffSets = null;
        }
    }

    private int augmentDegree(RelationshipDirection direction, int typeId) {
        int degree = 0;
        if (this.hasAddedRelationships()) {
            degree = this.relationshipsAdded.augmentDegree(direction, degree, typeId);
        }
        if (this.hasRemovedRelationships()) {
            degree = this.relationshipsRemoved.augmentDegree(direction, degree, typeId);
        }
        return degree;
    }

    public boolean fillDegrees(RelationshipSelection selection, Degrees.Mutator degrees) {
        IntIterator txTypes = this.getAddedAndRemovedRelationshipTypes().intIterator();
        while (txTypes.hasNext()) {
            int loop;
            int incoming;
            int outgoing;
            int type = txTypes.next();
            if (!selection.test(type) || degrees.add(type, outgoing = selection.test(RelationshipDirection.OUTGOING) ? this.augmentDegree(RelationshipDirection.OUTGOING, type) : 0, incoming = selection.test(RelationshipDirection.INCOMING) ? this.augmentDegree(RelationshipDirection.INCOMING, type) : 0, loop = selection.test(RelationshipDirection.LOOP) ? this.augmentDegree(RelationshipDirection.LOOP, type) : 0)) continue;
            return false;
        }
        return true;
    }

    boolean hasAddedRelationships() {
        return this.relationshipsAdded != null;
    }

    public boolean hasAddedRelationships(int type) {
        return this.relationshipsAdded != null && this.relationshipsAdded.hasRelationships(type);
    }

    boolean hasRemovedRelationships() {
        return this.relationshipsRemoved != null && !this.relationshipsRemoved.isEmpty();
    }

    boolean hasUpdatedRelationships() {
        return this.relationshipsUpdated != null;
    }

    boolean hasRelationshipChanges() {
        return this.hasAddedRelationships() || this.hasRemovedRelationships() || this.hasUpdatedRelationships();
    }

    public LongIterator getAddedRelationships() {
        return this.relationshipsAdded != null ? this.relationshipsAdded.getRelationships() : ImmutableEmptyLongIterator.INSTANCE;
    }

    public LongIterator getAddedRelationships(Direction direction) {
        return this.relationshipsAdded != null ? this.relationshipsAdded.getRelationships(direction) : ImmutableEmptyLongIterator.INSTANCE;
    }

    public LongIterator getAddedRelationships(Direction direction, int relType) {
        return this.relationshipsAdded != null ? this.relationshipsAdded.getRelationships(direction, relType) : ImmutableEmptyLongIterator.INSTANCE;
    }

    public LongIterator getAddedRelationships(RelationshipDirection direction, int relType) {
        return this.relationshipsAdded != null ? this.relationshipsAdded.getRelationships(direction, relType) : ImmutableEmptyLongIterator.INSTANCE;
    }

    public IntIterable getAddedRelationshipTypes() {
        return this.relationshipsAdded != null ? this.relationshipsAdded.relationshipTypes() : IntSets.immutable.empty();
    }

    public IntIterable getAddedAndRemovedRelationshipTypes() {
        if (this.relationshipsAdded == null && this.relationshipsRemoved == null) {
            return IntSets.immutable.empty();
        }
        if (this.relationshipsAdded != null && this.relationshipsRemoved != null) {
            MutableIntSet types = IntSets.mutable.withAll((IntIterable)this.relationshipsAdded.relationshipTypes());
            types.addAll((IntIterable)this.relationshipsRemoved.relationshipTypes());
            return types;
        }
        return this.relationshipsAdded != null ? this.relationshipsAdded.relationshipTypes() : this.relationshipsRemoved.relationshipTypes();
    }

    RelationshipModifications.RelationshipBatch additionsAsRelationshipBatch(RelationshipModifications.IdDataDecorator decorator) {
        return new RelationshipBatchImpl(this.relationshipsAdded, decorator);
    }

    RelationshipModifications.RelationshipBatch removalsAsRelationshipBatch(RelationshipModifications.IdDataDecorator decorator) {
        return new RelationshipBatchImpl(this.relationshipsRemoved, decorator);
    }

    void visitAddedIdsSplit(RelationshipModifications.InterruptibleTypeIdsVisitor visitor, RelationshipModifications.IdDataDecorator idDataDecorator) {
        if (this.hasAddedRelationships()) {
            this.relationshipsAdded.visitIdsSplit(visitor, idDataDecorator);
        }
    }

    void visitRemovedIdsSplit(RelationshipModifications.InterruptibleTypeIdsVisitor visitor) {
        if (this.hasRemovedRelationships()) {
            this.relationshipsRemoved.visitIdsSplit(visitor, RelationshipModifications.noAdditionalDataDecorator());
        }
    }

    void visitUpdatedIdsSplit(RelationshipModifications.InterruptibleTypeIdsVisitor visitor, RelationshipModifications.IdDataDecorator relationshipVisit) {
        if (this.hasUpdatedRelationships()) {
            this.relationshipsUpdated.visitIdsSplit(visitor, relationshipVisit);
        }
    }

    boolean isDeleted() {
        return this.deleted;
    }

    boolean isAddedInThisBatch() {
        return this.addedInThisBatch;
    }

    void markAsDeleted() {
        this.deleted = true;
        this.clear();
    }

    private static class RelationshipBatchImpl
    implements RelationshipModifications.RelationshipBatch {
        private final RelationshipChangesForNode relationships;
        private final RelationshipModifications.IdDataDecorator decorator;

        RelationshipBatchImpl(RelationshipChangesForNode relationships, RelationshipModifications.IdDataDecorator decorator) {
            this.relationships = relationships;
            this.decorator = decorator;
        }

        public int size() {
            return this.relationships != null ? this.relationships.totalCount() : 0;
        }

        public boolean isEmpty() {
            return this.relationships == null;
        }

        public <E extends Exception> void forEach(RelationshipVisitorWithProperties<E> relationship) throws E {
            this.relationships.visitIds(id -> this.decorator.accept(id, relationship));
        }
    }
}

