/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics.providers;

import java.nio.file.Path;
import java.util.Comparator;
import java.util.Map;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.diagnostics.NamedDiagnosticsProvider;

public class ConfigDiagnostics
extends NamedDiagnosticsProvider {
    private final Config config;

    public ConfigDiagnostics(Config config) {
        super("DBMS config");
        this.config = config;
    }

    public void dump(DiagnosticsLogger logger) {
        if (this.config.getDeclaredSettings().values().stream().noneMatch(arg_0 -> ((Config)this.config).isExplicitlySet(arg_0))) {
            logger.log("No provided DBMS settings.");
        } else {
            logger.log("DBMS provided settings:");
            this.config.getDeclaredSettings().entrySet().stream().filter(entry -> this.config.isExplicitlySet((Setting)entry.getValue())).sorted(Map.Entry.comparingByKey()).forEachOrdered(e -> {
                String value = ((SettingImpl)e.getValue()).valueToString(this.config.get((Setting)e.getValue()));
                logger.log(String.format("%s=%s", e.getKey(), value));
            });
        }
        logger.log("Directories in use:");
        this.config.getDeclaredSettings().values().stream().filter(setting -> ConfigDiagnostics.isImmutablePathSetting((Setting<Object>)setting, this.config.get(setting))).sorted(Comparator.comparing(Setting::name)).forEachOrdered(setting -> {
            String value = ((SettingImpl)setting).valueToString(this.config.get(setting));
            logger.log(String.format("%s=%s", setting.name(), value));
        });
    }

    private static boolean isImmutablePathSetting(Setting<Object> setting, Object value) {
        SettingImpl settingImpl = (SettingImpl)setting;
        if (SettingValueParsers.PATH.getType().equals(settingImpl.parser().getType()) && value instanceof Path) {
            Path path = (Path)value;
            return ConfigDiagnostics.isDirectory(path) && !settingImpl.internal() && !settingImpl.dynamic();
        }
        return false;
    }

    private static boolean isDirectory(Path path) {
        Path fileName = path.getFileName();
        return fileName == null || !fileName.toString().contains(".");
    }
}

