/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.diagnostics.DiagnosticsReportSource;

public final class DiagnosticsReportSources {
    private DiagnosticsReportSources() {
    }

    public static DiagnosticsReportSource newDiagnosticsFile(String destination, FileSystemAbstraction fs, Path source) {
        return new DiagnosticsFileReportSource(destination, fs, source);
    }

    public static List<DiagnosticsReportSource> newDiagnosticsRotatingFile(String destinationFolder, FileSystemAbstraction fs, Path file) {
        return DiagnosticsReportSources.newDiagnosticsMatchingFiles(destinationFolder, fs, file.getParent(), path -> path.getFileName().toString().startsWith(file.getFileName().toString()));
    }

    public static List<DiagnosticsReportSource> newDiagnosticsMatchingFiles(String destinationFolder, FileSystemAbstraction fs, Path sourceFolder, DirectoryStream.Filter<Path> filter) {
        ArrayList<DiagnosticsReportSource> files = new ArrayList<DiagnosticsReportSource>();
        try {
            Path[] paths = fs.listFiles(sourceFolder, filter);
            if (paths != null) {
                for (Path path : paths) {
                    files.add(DiagnosticsReportSources.newDiagnosticsFile(destinationFolder + path.getFileName().toString(), fs, path));
                }
            }
        }
        catch (IOException e) {
            files.add(DiagnosticsReportSources.newDiagnosticsString(destinationFolder + "error", () -> "Error reading files in directory: " + e.getMessage()));
        }
        return files;
    }

    public static DiagnosticsReportSource newDiagnosticsString(String destination, Supplier<String> messageSupplier) {
        return new DiagnosticsStringReportSource(destination, messageSupplier);
    }

    private static class DiagnosticsFileReportSource
    implements DiagnosticsReportSource {
        private final String destination;
        private final FileSystemAbstraction fs;
        private final Path source;

        DiagnosticsFileReportSource(String destination, FileSystemAbstraction fs, Path source) {
            this.destination = destination;
            this.fs = fs;
            this.source = source;
        }

        @Override
        public String destinationPath() {
            return this.destination;
        }

        @Override
        public InputStream newInputStream() throws IOException {
            return this.fs.openAsInputStream(this.source);
        }

        @Override
        public long estimatedSize() {
            try {
                return this.fs.getFileSize(this.source);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static class DiagnosticsStringReportSource
    implements DiagnosticsReportSource {
        private final String destination;
        private final Supplier<String> messageSupplier;

        private DiagnosticsStringReportSource(String destination, Supplier<String> messageSupplier) {
            this.destination = destination;
            this.messageSupplier = messageSupplier;
        }

        @Override
        public String destinationPath() {
            return this.destination;
        }

        @Override
        public InputStream newInputStream() {
            String message = this.messageSupplier.get();
            return new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8));
        }

        @Override
        public long estimatedSize() {
            return 0L;
        }
    }
}

