/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.NormalizedCatalogEntry;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public class MapCachingDatabaseReferenceRepository
implements DatabaseReferenceRepository.Caching {
    private DatabaseReferenceRepository delegate;
    private volatile Map<NormalizedDatabaseName, DatabaseReference> databaseRefsByName = new ConcurrentHashMap<NormalizedDatabaseName, DatabaseReference>();
    private volatile Map<NormalizedCatalogEntry, DatabaseReference> databaseRefsByCatalogEntry = new ConcurrentHashMap<NormalizedCatalogEntry, DatabaseReference>();
    private volatile Map<UUID, DatabaseReference> databaseRefsByUUID = new ConcurrentHashMap<UUID, DatabaseReference>();

    public MapCachingDatabaseReferenceRepository(DatabaseReferenceRepository delegate) {
        this.delegate = delegate;
    }

    public MapCachingDatabaseReferenceRepository() {
        this(null);
    }

    public void setDelegate(DatabaseReferenceRepository delegate) {
        this.delegate = delegate;
    }

    @Override
    public Optional<DatabaseReference> getByAlias(NormalizedCatalogEntry catalogEntry) {
        return Optional.ofNullable(this.databaseRefsByCatalogEntry.computeIfAbsent(catalogEntry, entry -> {
            DatabaseReference databaseRef = this.lookupReferenceOnDelegate((NormalizedCatalogEntry)entry);
            if (databaseRef == null) {
                return null;
            }
            this.databaseRefsByUUID.putIfAbsent(databaseRef.id(), databaseRef);
            return databaseRef;
        }));
    }

    @Override
    public Optional<DatabaseReference> getByAlias(NormalizedDatabaseName databaseAlias) {
        return Optional.ofNullable(this.databaseRefsByName.computeIfAbsent(databaseAlias, alias -> {
            DatabaseReference databaseRef = this.lookupReferenceOnDelegate((NormalizedDatabaseName)alias);
            if (databaseRef == null) {
                return null;
            }
            this.databaseRefsByCatalogEntry.putIfAbsent(databaseRef.catalogEntry(), databaseRef);
            this.databaseRefsByUUID.putIfAbsent(databaseRef.id(), databaseRef);
            return databaseRef;
        }));
    }

    @Override
    public Optional<DatabaseReference> getByUuid(UUID uuid) {
        return Optional.ofNullable(this.databaseRefsByUUID.computeIfAbsent(uuid, uuid1 -> {
            DatabaseReference databaseRef = this.lookupReferenceByUuidOnDelegate((UUID)uuid1);
            if (databaseRef == null) {
                return null;
            }
            this.databaseRefsByName.putIfAbsent(databaseRef.fullName(), databaseRef);
            this.databaseRefsByCatalogEntry.putIfAbsent(databaseRef.catalogEntry(), databaseRef);
            return databaseRef;
        }));
    }

    private DatabaseReference lookupReferenceOnDelegate(NormalizedDatabaseName databaseName) {
        return this.delegate.getByAlias(databaseName).orElse(null);
    }

    private DatabaseReference lookupReferenceOnDelegate(NormalizedCatalogEntry catalogEntry) {
        return this.delegate.getByAlias(catalogEntry).orElse(null);
    }

    private DatabaseReference lookupReferenceByUuidOnDelegate(UUID databaseId) {
        return this.delegate.getByUuid(databaseId).orElse(null);
    }

    @Override
    public Set<DatabaseReference> getAllDatabaseReferences() {
        return this.delegate.getAllDatabaseReferences();
    }

    @Override
    public Set<DatabaseReferenceImpl.Internal> getInternalDatabaseReferences() {
        return this.delegate.getInternalDatabaseReferences();
    }

    @Override
    public Set<DatabaseReferenceImpl.External> getExternalDatabaseReferences() {
        return this.delegate.getExternalDatabaseReferences();
    }

    @Override
    public Set<DatabaseReferenceImpl.Composite> getCompositeDatabaseReferences() {
        return this.delegate.getCompositeDatabaseReferences();
    }

    @Override
    public void invalidateAll() {
        this.databaseRefsByName = new ConcurrentHashMap<NormalizedDatabaseName, DatabaseReference>();
        this.databaseRefsByCatalogEntry = new ConcurrentHashMap<NormalizedCatalogEntry, DatabaseReference>();
        this.databaseRefsByUUID = new ConcurrentHashMap<UUID, DatabaseReference>();
    }
}

