/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.exceptions.Status;

public abstract class RepeatedSchemaComponentException
extends SchemaKernelException {
    private final SchemaDescriptor schema;
    private final SchemaKernelException.OperationContext context;
    private final SchemaComponent component;

    RepeatedSchemaComponentException(Status status, SchemaDescriptor schema, SchemaKernelException.OperationContext context, SchemaComponent component, TokenNameLookup tokenNameLookup) {
        super(status, RepeatedSchemaComponentException.format(schema, context, tokenNameLookup, component));
        this.schema = schema;
        this.context = context;
        this.component = component;
    }

    RepeatedSchemaComponentException(ErrorGqlStatusObject gqlStatusObject, Status status, SchemaDescriptor schema, SchemaKernelException.OperationContext context, SchemaComponent component, TokenNameLookup tokenNameLookup) {
        super(gqlStatusObject, status, RepeatedSchemaComponentException.format(schema, context, tokenNameLookup, component));
        this.schema = schema;
        this.context = context;
        this.component = component;
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return RepeatedSchemaComponentException.format(this.schema, this.context, tokenNameLookup, this.component);
    }

    private static String format(SchemaDescriptor schema, SchemaKernelException.OperationContext context, TokenNameLookup tokenNameLookup, SchemaComponent component) {
        String schemaName = switch (context) {
            default -> throw new MatchException(null, null);
            case SchemaKernelException.OperationContext.INDEX_CREATION -> "Index";
            case SchemaKernelException.OperationContext.CONSTRAINT_CREATION -> "Constraint";
        };
        return String.format("%s on %s includes a %s more than once.", schemaName, schema.userDescription(tokenNameLookup), component.name);
    }

    static enum SchemaComponent {
        PROPERTY("property"),
        LABEL("label"),
        RELATIONSHIP_TYPE("relationship type");

        private final String name;

        private SchemaComponent(String name) {
            this.name = name;
        }
    }
}

