/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Readables;
import org.neo4j.function.Function;
import org.neo4j.function.Supplier;
import org.neo4j.function.Suppliers;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityDecorators;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputEntityDeserializer;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputGroupsDeserializer;

public class InputGroupsDeserializerTest {
    @Test
    public void shouldBeAbleToAskForSourceInformationEvenBetweenTwoSources() throws Exception {
        List<DataFactory> data = Arrays.asList(this.data(":ID\n1"), this.data("2"));
        final AtomicInteger flips = new AtomicInteger();
        InputGroupsDeserializer<InputNode> deserializer = new InputGroupsDeserializer<InputNode>(data.iterator(), DataFactories.defaultFormatNodeFileHeader(), this.lowBufferSize(Configuration.COMMAS), IdType.INTEGER){

            protected InputEntityDeserializer<InputNode> entityDeserializer(CharSeeker dataStream, Header dataHeader, Function<InputNode, InputNode> decorator) {
                if (flips.get() == 0) {
                    Assert.assertNotNull((Object)this.sourceDescription());
                } else {
                    Assert.assertEquals((Object)("" + flips.get()), (Object)this.sourceDescription());
                }
                flips.incrementAndGet();
                InputEntityDeserializer result = (InputEntityDeserializer)Mockito.mock(InputEntityDeserializer.class);
                Mockito.when((Object)result.sourceDescription()).thenReturn((Object)String.valueOf(flips.get()));
                return result;
            }
        };
        IteratorUtil.count((Iterator)deserializer);
        Assert.assertEquals((long)2L, (long)flips.get());
    }

    private Configuration lowBufferSize(Configuration conf) {
        return new Configuration.Overriden(conf){

            public int bufferSize() {
                return 100;
            }
        };
    }

    private DataFactory<InputNode> data(String string) {
        return DataFactories.data((Function)InputEntityDecorators.NO_NODE_DECORATOR, (Supplier)Suppliers.singleton((Object)Readables.wrap((Reader)new StringReader(string))));
    }
}

