/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.function.Function;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityDecorators;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;

public class InputEntityDecoratorsTest {
    @Test
    public void shouldProvideDefaultRelationshipType() throws Exception {
        String defaultType = "TYPE";
        Function decorator = InputEntityDecorators.defaultRelationshipType((String)defaultType);
        InputRelationship relationship = new InputRelationship("source", 1L, 0L, InputEntity.NO_PROPERTIES, null, (Object)"start", (Object)"end", null, null);
        relationship = (InputRelationship)decorator.apply((Object)relationship);
        Assert.assertEquals((Object)defaultType, (Object)relationship.type());
    }

    @Test
    public void shouldNotOverrideAlreadySetRelationshipType() throws Exception {
        String defaultType = "TYPE";
        Function decorator = InputEntityDecorators.defaultRelationshipType((String)defaultType);
        String customType = "CUSTOM_TYPE";
        InputRelationship relationship = new InputRelationship("source", 1L, 0L, InputEntity.NO_PROPERTIES, null, (Object)"start", (Object)"end", customType, null);
        relationship = (InputRelationship)decorator.apply((Object)relationship);
        Assert.assertEquals((Object)customType, (Object)relationship.type());
    }

    @Test
    public void shouldNotOverrideAlreadySetRelationshipTypeId() throws Exception {
        String defaultType = "TYPE";
        Function decorator = InputEntityDecorators.defaultRelationshipType((String)defaultType);
        Integer typeId = 5;
        InputRelationship relationship = new InputRelationship("source", 1L, 0L, InputEntity.NO_PROPERTIES, null, (Object)"start", (Object)"end", null, typeId);
        relationship = (InputRelationship)decorator.apply((Object)relationship);
        Assert.assertEquals(null, (Object)relationship.type());
        Assert.assertEquals((long)typeId.intValue(), (long)relationship.typeId());
    }

    @Test
    public void shouldAddLabelsToNodeWithoutLabels() throws Exception {
        Object[] toAdd = new String[]{"Add1", "Add2"};
        Function decorator = InputEntityDecorators.additiveLabels((String[])toAdd);
        InputNode node = new InputNode("source", 1L, 0L, (Object)"id", InputEntity.NO_PROPERTIES, null, null, null);
        node = (InputNode)decorator.apply((Object)node);
        Assert.assertArrayEquals((Object[])toAdd, (Object[])node.labels());
    }

    @Test
    public void shouldAddMissingLabels() throws Exception {
        Object[] toAdd = new String[]{"Add1", "Add2"};
        Function decorator = InputEntityDecorators.additiveLabels((String[])toAdd);
        Object[] nodeLabels = new String[]{"SomeOther"};
        InputNode node = new InputNode("source", 1L, 0L, (Object)"id", InputEntity.NO_PROPERTIES, null, (String[])nodeLabels, null);
        node = (InputNode)decorator.apply((Object)node);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])ArrayUtil.union((Object[])toAdd, (Object[])nodeLabels)), (Object)IteratorUtil.asSet((Object[])node.labels()));
    }

    @Test
    public void shouldNotTouchLabelsIfNodeHasLabelFieldSet() throws Exception {
        String[] toAdd = new String[]{"Add1", "Add2"};
        Function decorator = InputEntityDecorators.additiveLabels((String[])toAdd);
        long labelField = 123L;
        InputNode node = new InputNode("source", 1L, 0L, (Object)"id", InputEntity.NO_PROPERTIES, null, null, Long.valueOf(labelField));
        node = (InputNode)decorator.apply((Object)node);
        Assert.assertNull((Object)node.labels());
        Assert.assertEquals((long)labelField, (long)node.labelField());
    }

    @Test
    public void shouldCramMultipleDecoratorsIntoOne() throws Exception {
        Function decorator1 = (Function)Mockito.spy((Object)new IdentityDecorator());
        Function decorator2 = (Function)Mockito.spy((Object)new IdentityDecorator());
        Function multi = InputEntityDecorators.decorators((Function[])new Function[]{decorator1, decorator2});
        InputNode node = (InputNode)Mockito.mock(InputNode.class);
        multi.apply((Object)node);
        InOrder order = Mockito.inOrder((Object[])new Object[]{decorator1, decorator2});
        ((Function)order.verify((Object)decorator1, Mockito.times((int)1))).apply((Object)node);
        ((Function)order.verify((Object)decorator2, Mockito.times((int)1))).apply((Object)node);
        order.verifyNoMoreInteractions();
    }

    private static class IdentityDecorator
    implements Function<InputNode, InputNode> {
        private IdentityDecorator() {
        }

        public InputNode apply(InputNode from) throws RuntimeException {
            return from;
        }
    }
}

