/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.File;
import java.io.IOException;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.PropertyEncoderStep;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;

public class PropertyEncoderStepTest {
    @Rule
    public final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    private NeoStores neoStores;
    private PageCache pageCache;

    @Before
    public void setUpNeoStore() {
        File storeDir = new File("dir");
        this.pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fsRule.get());
        StoreFactory storeFactory = new StoreFactory((FileSystemAbstraction)this.fsRule.get(), storeDir, this.pageCache, (LogProvider)NullLogProvider.getInstance());
        this.neoStores = storeFactory.openAllNeoStores(true);
    }

    @After
    public void closeNeoStore() throws IOException {
        this.neoStores.close();
        this.pageCache.close();
    }

    @Test
    public void shouldGrowPropertyBlocksArrayProperly() throws Exception {
        StageControl control = (StageControl)Mockito.mock(StageControl.class);
        BatchingTokenRepository.BatchingPropertyKeyTokenRepository tokens = new BatchingTokenRepository.BatchingPropertyKeyTokenRepository((TokenStore)this.neoStores.getPropertyKeyTokenStore(), 0);
        PropertyEncoderStep step = new PropertyEncoderStep(control, Configuration.DEFAULT, tokens, this.neoStores.getPropertyStore());
        Step downstream = (Step)Mockito.mock(Step.class);
        step.setDownstream(downstream);
        step.start(0);
        step.receive(0L, this.smallbatch());
        step.endOfUpstream();
        this.awaitCompleted((Step<?>)step, control);
        ((Step)Mockito.verify((Object)downstream)).receive(Matchers.anyLong(), Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{control});
    }

    private void awaitCompleted(Step<?> step, StageControl control) throws InterruptedException {
        while (!step.isCompleted()) {
            Thread.sleep(10L);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{control});
        }
    }

    private Batch<InputNode, NodeRecord> smallbatch() {
        return new Batch((Object[])new InputNode[]{new InputNode("source", 1L, 0L, (Object)"1", new Object[]{"key1", "value1", "key2", "value2", "key3", "value3", "key4", "value4", "key5", "value5"}, null, new String[]{"label1", "label2", "label3", "label4"}, null)});
    }
}

