/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Resource;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.OtherThreadRule;
import org.neo4j.unsafe.impl.batchimport.ParallelizationCoordinator;

public class ParallelizationCoordinatorTest {
    @Rule
    public final OtherThreadRule<Void> t2 = new OtherThreadRule();

    @Test
    public void shouldSerializeNonParallelizableBatches() throws Exception {
        Future<Resource> r2Future;
        ParallelizationCoordinator coordinator = new ParallelizationCoordinator();
        try (Resource r1 = coordinator.coordinate(false);){
            r2Future = this.t2.execute(this.coordinate(coordinator, false));
            this.waitUntilAwaitingLock(this.t2);
        }
        this.t2.execute(this.close(r2Future.get())).get();
    }

    @Test
    public void shouldParallelizeBatches() throws Exception {
        ParallelizationCoordinator coordinator = new ParallelizationCoordinator();
        Resource r1 = coordinator.coordinate(true);
        Resource r2 = coordinator.coordinate(true);
        r1.close();
        r2.close();
    }

    @Test
    public void shouldHaveNonParallelizableBatchAwaitPreviousParallelizable() throws Exception {
        ParallelizationCoordinator coordinator = new ParallelizationCoordinator();
        Resource r1 = coordinator.coordinate(true);
        Resource r2 = coordinator.coordinate(true);
        Future<Resource> r3Future = this.t2.execute(this.coordinate(coordinator, false));
        this.waitUntilAwaitingLock(this.t2);
        r2.close();
        r1.close();
        this.t2.execute(this.close(r3Future.get())).get();
    }

    private void waitUntilAwaitingLock(OtherThreadRule<Void> thread) throws TimeoutException {
        OtherThreadExecutor.WaitDetails details;
        while (!(details = thread.get().waitUntilWaiting()).isAt(ParallelizationCoordinator.class, "coordinate")) {
        }
    }

    private OtherThreadExecutor.WorkerCommand<Void, Resource> coordinate(final ParallelizationCoordinator coordinator, final boolean parallelizable) {
        return new OtherThreadExecutor.WorkerCommand<Void, Resource>(){

            @Override
            public Resource doWork(Void state) throws Exception {
                return coordinator.coordinate(parallelizable);
            }
        };
    }

    private OtherThreadExecutor.WorkerCommand<Void, Void> close(final Resource resource) {
        return new OtherThreadExecutor.WorkerCommand<Void, Void>(){

            @Override
            public Void doWork(Void state) throws Exception {
                resource.close();
                return null;
            }
        };
    }
}

