/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.StoreLocker;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.test.ReflectionUtil;
import org.neo4j.test.TargetDirectory;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;

public class BatchInserterImplTest {
    @Rule
    public TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void testHonorsPassedInParams() throws Exception {
        BatchInserter inserter = BatchInserters.inserter((File)this.testDirectory.graphDbDir(), (Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), "280K", GraphDatabaseSettings.mapped_memory_page_size.name(), "1K"}));
        NeoStores neoStores = ReflectionUtil.getPrivateField(inserter, "neoStores", NeoStores.class);
        PageCache pageCache = ReflectionUtil.getPrivateField(neoStores, "pageCache", PageCache.class);
        inserter.shutdown();
        int mappedMemoryTotalSize = pageCache.maxCachedPages() * pageCache.pageSize();
        Assert.assertThat((String)"memory mapped config is active", (Object)mappedMemoryTotalSize, (Matcher)Matchers.is((Object)286720));
    }

    @Test
    public void testCreatesStoreLockFile() throws Exception {
        File file = this.testDirectory.graphDbDir();
        BatchInserter inserter = BatchInserters.inserter((String)file.getAbsolutePath());
        Assert.assertThat((Object)new File(file, "store_lock").exists(), (Matcher)CoreMatchers.equalTo((Object)true));
        inserter.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailsOnExistingStoreLockFile() throws IOException {
        File parent = this.testDirectory.graphDbDir();
        StoreLocker lock = new StoreLocker((FileSystemAbstraction)new DefaultFileSystemAbstraction());
        lock.checkLock(parent);
        try {
            BatchInserters.inserter((String)parent.getAbsolutePath());
            Assert.fail();
        }
        catch (StoreLockException storeLockException) {
        }
        finally {
            lock.release();
        }
    }
}

