/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import sun.reflect.FieldAccessor;
import sun.reflect.ReflectionFactory;

public class ReflectionUtil {
    private static final ReflectionFactory reflectionFactory = ReflectionFactory.getReflectionFactory();

    public static void setStaticFinalField(Field field, Object value) throws NoSuchFieldException, IllegalAccessException {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        int modifiers = modifiersField.getInt(field);
        modifiersField.setInt(field, modifiers &= 0xFFFFFFEF);
        FieldAccessor fieldAccessor = reflectionFactory.newFieldAccessor(field, false);
        fieldAccessor.set(null, value);
    }

    public static <T> T getPrivateField(Object target, String fieldName, Class<T> fieldType) throws Exception {
        Class<?> type = target.getClass();
        Field field = ReflectionUtil.getField(fieldName, type);
        if (!fieldType.isAssignableFrom(field.getType())) {
            throw new IllegalArgumentException("Field type does not match " + field.getType() + " is no subclass of " + "" + fieldType);
        }
        field.setAccessible(true);
        return fieldType.cast(field.get(target));
    }

    public static String verifyMethodExists(Class<?> owner, String methodName) {
        for (Method method : owner.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return methodName;
        }
        throw new IllegalArgumentException("Method '" + methodName + "' does not exist in class " + owner);
    }

    private static Field getField(String fieldName, Class<? extends Object> type) throws NoSuchFieldException {
        if (type == null) {
            throw new NoSuchFieldException(fieldName);
        }
        try {
            Field field = type.getDeclaredField(fieldName);
            if (field != null) {
                return field;
            }
        }
        catch (NoSuchFieldError noSuchFieldError) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return ReflectionUtil.getField(fieldName, type.getSuperclass());
    }
}

