/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.Strings;

public final class Assert {
    private Assert() {
    }

    public static void assertObjectOrArrayEquals(Object expected, Object actual) {
        Assert.assertObjectOrArrayEquals("", expected, actual);
    }

    public static void assertObjectOrArrayEquals(String message, Object expected, Object actual) {
        if (expected.getClass().isArray() ? !ArrayUtil.equals((Object)expected, (Object)actual) : !Objects.equals(expected, actual)) {
            throw Assert.newAssertionError(message, expected, actual);
        }
    }

    public static <T, E extends Exception> void assertEventually(String reason, ThrowingSupplier<T, E> actual, Matcher<? super T> matcher, long timeout, TimeUnit timeUnit) throws E {
        boolean matched;
        long waitUntil = System.currentTimeMillis() + timeUnit.toMillis(timeout);
        while (!(matched = matcher.matches(actual.get())) && System.currentTimeMillis() <= waitUntil) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!matched) {
            StringDescription description = new StringDescription();
            description.appendText(reason).appendText("\nExpected: ").appendDescriptionOf(matcher).appendText("\n     but: ");
            matcher.describeMismatch(actual, (Description)description);
            throw new AssertionError((Object)("Timeout hit (" + timeout + " " + timeUnit.toString().toLowerCase() + ") while waiting for condition to match: " + description.toString()));
        }
    }

    private static AssertionError newAssertionError(String message, Object expected, Object actual) {
        return new AssertionError((Object)((message == null || message.isEmpty() ? "" : message + "\n") + "Expected: " + Strings.prettyPrint((Object)expected) + ", actual: " + Strings.prettyPrint((Object)actual)));
    }
}

