/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metatest;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.metatest.TestJavaTestDocsGenerator;
import org.neo4j.test.AsciiDocGenerator;
import org.neo4j.test.TargetDirectory;

public class AsciiDocGeneratorTest {
    @Rule
    public TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());
    private File sectionDirectory;

    @Before
    public void setup() {
        this.sectionDirectory = new File(this.testDirectory.directory("testasciidocs"), "testsection");
    }

    @Test
    public void dumpToSeparateFile() throws IOException {
        String reference = AsciiDocGenerator.dumpToSeparateFile(this.sectionDirectory, "test1", ".title1\ntest1-content");
        Assert.assertEquals((Object)".title1\ninclude::includes/test1.asciidoc[]\n", (Object)reference);
        File includeDir = new File(this.sectionDirectory, "includes");
        File includeFile = new File(includeDir, "test1.asciidoc");
        Assert.assertTrue((boolean)includeFile.canRead());
        String fileContent = TestJavaTestDocsGenerator.readFileAsString(includeFile);
        Assert.assertEquals((Object)"test1-content", (Object)fileContent);
    }

    @Test
    public void dumpToSeparateFileWithType() throws IOException {
        String reference = AsciiDocGenerator.dumpToSeparateFileWithType(this.sectionDirectory, "console", "test2-content");
        Assert.assertEquals((Object)"include::includes/console-1.asciidoc[]\n", (Object)reference);
        File includeDir = new File(this.sectionDirectory, "includes");
        File includeFile = new File(includeDir, "console-1.asciidoc");
        String fileContent = TestJavaTestDocsGenerator.readFileAsString(includeFile);
        Assert.assertEquals((Object)"test2-content", (Object)fileContent);
        AsciiDocGenerator.dumpToSeparateFileWithType(this.sectionDirectory, "console", "test3-content");
        includeFile = new File(includeDir, "console-2.asciidoc");
        fileContent = TestJavaTestDocsGenerator.readFileAsString(includeFile);
        Assert.assertEquals((Object)"test3-content", (Object)fileContent);
    }
}

