/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.FakeClock;
import org.neo4j.kernel.impl.util.CappedOperation;

public class CappedOperationTest {
    @Test
    public void shouldTriggerOnSingleSwitch() throws Exception {
        AtomicInteger triggerCount = new AtomicInteger();
        CappedOperation<String> operation = this.countingCappedOperations(triggerCount, CappedOperation.count((long)2L));
        Assert.assertEquals((long)0L, (long)triggerCount.get());
        operation.event((Object)"test");
        Assert.assertEquals((long)0L, (long)triggerCount.get());
        operation.event((Object)"test");
        Assert.assertEquals((long)1L, (long)triggerCount.get());
        operation.event((Object)"test");
        Assert.assertEquals((long)1L, (long)triggerCount.get());
        operation.event((Object)"test");
        Assert.assertEquals((long)2L, (long)triggerCount.get());
    }

    @Test
    public void shouldTriggerOnDifferentItemsEvenIfCountSwitch() throws Exception {
        AtomicInteger triggerCount = new AtomicInteger();
        CappedOperation<String> operation = this.countingCappedOperations(triggerCount, CappedOperation.count((long)2L), CappedOperation.differentItems());
        operation.event((Object)"test");
        Assert.assertEquals((long)1L, (long)triggerCount.get());
        operation.event((Object)"OTHER");
        Assert.assertEquals((long)2L, (long)triggerCount.get());
        operation.event((Object)"OTHER");
        Assert.assertEquals((long)2L, (long)triggerCount.get());
        operation.event((Object)"OTHER");
        Assert.assertEquals((long)3L, (long)triggerCount.get());
    }

    @Test
    public void shouldTriggerBasedOnTime() throws Exception {
        AtomicInteger triggerCount = new AtomicInteger();
        FakeClock clock = new FakeClock(12345678L, TimeUnit.MILLISECONDS);
        CappedOperation<String> operation = this.countingCappedOperations(triggerCount, CappedOperation.time((Clock)clock, (long)1500L, (TimeUnit)TimeUnit.MILLISECONDS));
        operation.event((Object)"event");
        Assert.assertEquals((long)1L, (long)triggerCount.get());
        clock.forward(1499L, TimeUnit.MILLISECONDS);
        operation.event((Object)"event");
        Assert.assertEquals((long)1L, (long)triggerCount.get());
        clock.forward(2L, TimeUnit.MILLISECONDS);
        operation.event((Object)"event");
        Assert.assertEquals((long)2L, (long)triggerCount.get());
        clock.forward(1600L, TimeUnit.MILLISECONDS);
        operation.event((Object)"event");
        Assert.assertEquals((long)3L, (long)triggerCount.get());
    }

    private CappedOperation<String> countingCappedOperations(final AtomicInteger triggerCount, CappedOperation.Switch ... openers) {
        return new CappedOperation<String>(openers){

            protected void triggered(String event) {
                triggerCount.incrementAndGet();
            }
        };
    }
}

