/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.impl.traversal.TraversalTestBase;

public class TestEvaluators
extends TraversalTestBase {
    private Transaction tx;

    @Before
    public void createGraph() {
        this.createGraph("a A b", "b B c", "c B d", "d C e", "e A j", "b C h", "h B i", "i C k", "a B f", "f C g");
        this.tx = this.beginTx();
    }

    @After
    public void tearDown() {
        this.tx.close();
    }

    @Test
    public void lastRelationshipTypeEvaluator() throws Exception {
        Node a = this.getNodeWithName("a");
        this.expectPaths(Traversal.traversal().evaluator(Evaluators.lastRelationshipTypeIs((Evaluation)Evaluation.INCLUDE_AND_PRUNE, (Evaluation)Evaluation.EXCLUDE_AND_CONTINUE, (RelationshipType)Types.C, (RelationshipType[])new RelationshipType[0])).traverse(a), "a,b,c,d,e", "a,f,g", "a,b,h");
        this.expectPaths(Traversal.traversal().evaluator(Evaluators.lastRelationshipTypeIs((Evaluation)Evaluation.INCLUDE_AND_CONTINUE, (Evaluation)Evaluation.EXCLUDE_AND_CONTINUE, (RelationshipType)Types.C, (RelationshipType[])new RelationshipType[0])).traverse(a), "a,b,c,d,e", "a,f,g", "a,b,h", "a,b,h,i,k");
    }

    @Test
    public void endNodeIs() {
        Node a = this.getNodeWithName("a");
        Node c = this.getNodeWithName("c");
        Node h = this.getNodeWithName("h");
        Node g = this.getNodeWithName("g");
        this.expectPaths(Traversal.description().evaluator(Evaluators.includeWhereEndNodeIs((Node[])new Node[]{c, h, g})).traverse(a), "a,b,c", "a,b,h", "a,f,g");
        this.expectPaths(Traversal.description().evaluator(Evaluators.includeWhereEndNodeIs((Node[])new Node[]{g})).traverse(a), "a,f,g");
    }

    @Test
    public void depths() throws Exception {
        Node a = this.getNodeWithName("a");
        this.expectPaths(Traversal.traversal().evaluator(Evaluators.atDepth((int)1)).traverse(a), "a,b", "a,f");
        this.expectPaths(Traversal.traversal().evaluator(Evaluators.fromDepth((int)2)).traverse(a), "a,f,g", "a,b,h", "a,b,h,i", "a,b,h,i,k", "a,b,c", "a,b,c,d", "a,b,c,d,e", "a,b,c,d,e,j");
        this.expectPaths(Traversal.traversal().evaluator(Evaluators.toDepth((int)2)).traverse(a), "a", "a,b", "a,b,c", "a,b,h", "a,f", "a,f,g");
    }

    private static enum Types implements RelationshipType
    {
        A,
        B,
        C;

    }
}

