/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.pruning.FileCountThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.FileSizeThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategyFactory;
import org.neo4j.kernel.impl.transaction.log.pruning.Threshold;
import org.neo4j.kernel.impl.transaction.log.pruning.TransactionCountThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.TransactionTimespanThreshold;

public class LogPruneStrategyFactoryTest {
    @Test
    public void testLogPruneThresholdsByType() throws Exception {
        Assert.assertThat((Object)this.getPruneStrategy("files", "25", "25 files"), (Matcher)Matchers.instanceOf(FileCountThreshold.class));
        Assert.assertThat((Object)this.getPruneStrategy("size", "16G", "16G size"), (Matcher)Matchers.instanceOf(FileSizeThreshold.class));
        Assert.assertThat((Object)this.getPruneStrategy("txs", "4G", "4G txs"), (Matcher)Matchers.instanceOf(TransactionCountThreshold.class));
        Assert.assertThat((Object)this.getPruneStrategy("hours", "100", "100 hours"), (Matcher)Matchers.instanceOf(TransactionTimespanThreshold.class));
        Assert.assertThat((Object)this.getPruneStrategy("days", "100k", "100k days"), (Matcher)Matchers.instanceOf(TransactionTimespanThreshold.class));
    }

    private Threshold getPruneStrategy(String type, String value, String configValue) {
        FileSystemAbstraction fileSystem = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        return LogPruneStrategyFactory.getThresholdByType((FileSystemAbstraction)fileSystem, (String)type, (String)value, (String)configValue);
    }
}

