/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TestGraphDatabaseFactory;

public class CheckPointerIntegrationTest {
    private static final File storeDir = new File(System.getProperty("java.io.tmpdir"), "graph.db");
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private GraphDatabaseBuilder builder;
    private FileSystemAbstraction fs;

    @Before
    public void setup() throws IOException {
        this.fs = this.fsRule.get();
        this.fs.deleteRecursively(storeDir);
        this.builder = new TestGraphDatabaseFactory().setFileSystem(this.fs).newImpermanentDatabaseBuilder(storeDir);
    }

    @Test
    public void databaseShutdownDuringConstantCheckPointing() throws InterruptedException, IOException {
        GraphDatabaseService db = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, "0ms").setConfig(GraphDatabaseSettings.check_point_interval_tx, "1").setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, "1g").newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        Thread.sleep(10L);
        db.shutdown();
    }

    @Test
    public void shouldCheckPointBasedOnTime() throws Throwable {
        long seconds = 3L;
        GraphDatabaseService db = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, seconds + "s").setConfig(GraphDatabaseSettings.check_point_interval_tx, "10000").setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, "1g").newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        TimeUnit.SECONDS.sleep(seconds);
        TimeUnit.SECONDS.sleep(1L);
        db.shutdown();
        List<CheckPoint> checkPoints = new CheckPointCollector(storeDir, this.fs).find(0L);
        Assert.assertEquals((long)2L, (long)checkPoints.size());
    }

    @Test
    public void shouldCheckPointBasedOnTxCount() throws Throwable {
        GraphDatabaseService db = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, "300m").setConfig(GraphDatabaseSettings.check_point_interval_tx, "1").setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, "1g").newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        TimeUnit.SECONDS.sleep(11L);
        db.shutdown();
        List<CheckPoint> checkPoints = new CheckPointCollector(storeDir, this.fs).find(0L);
        Assert.assertEquals((long)2L, (long)checkPoints.size());
    }

    @Test
    public void shouldNotCheckPointWhenThereAreNoCommits() throws Throwable {
        long seconds = 1L;
        GraphDatabaseService db = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, seconds + "s").setConfig(GraphDatabaseSettings.check_point_interval_tx, "10000").setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, "1g").newGraphDatabase();
        TimeUnit.SECONDS.sleep(seconds);
        TimeUnit.SECONDS.sleep(1L);
        db.shutdown();
        List<CheckPoint> checkPoints = new CheckPointCollector(storeDir, this.fs).find(0L);
        Assert.assertEquals((long)1L, (long)checkPoints.size());
    }

    @Test
    public void shouldBeAbleToStartAndShutdownMultipleTimesTheDBWithoutCommittingTransactions() throws Throwable {
        GraphDatabaseBuilder graphDatabaseBuilder = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, "300m").setConfig(GraphDatabaseSettings.check_point_interval_tx, "10000").setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, "1g");
        graphDatabaseBuilder.newGraphDatabase().shutdown();
        graphDatabaseBuilder.newGraphDatabase().shutdown();
        List<CheckPoint> checkPoints = new CheckPointCollector(storeDir, this.fs).find(0L);
        Assert.assertEquals((long)2L, (long)checkPoints.size());
    }

    private static class CheckPointCollector {
        private final PhysicalLogFiles logFiles;
        private final FileSystemAbstraction fileSystem;
        private final LogEntryReader<ReadableLogChannel> logEntryReader;

        public CheckPointCollector(File directory, FileSystemAbstraction fileSystem) {
            this.fileSystem = fileSystem;
            this.logFiles = new PhysicalLogFiles(directory, fileSystem);
            this.logEntryReader = new VersionAwareLogEntryReader(LogEntryVersion.CURRENT.byteCode());
        }

        public List<CheckPoint> find(long version) throws IOException {
            PhysicalLogVersionedStoreChannel channel;
            ArrayList<CheckPoint> checkPoints = new ArrayList<CheckPoint>();
            while (version >= 0L && (channel = PhysicalLogFile.tryOpenForVersion((PhysicalLogFiles)this.logFiles, (FileSystemAbstraction)this.fileSystem, (long)version)) != null) {
                ReadAheadLogChannel recoveredDataChannel = new ReadAheadLogChannel((LogVersionedStoreChannel)channel, LogVersionBridge.NO_MORE_CHANNELS, 4096);
                try (LogEntryCursor cursor = new LogEntryCursor(this.logEntryReader, (ReadableLogChannel)recoveredDataChannel);){
                    while (cursor.next()) {
                        LogEntry entry = cursor.get();
                        if (!(entry instanceof CheckPoint)) continue;
                        checkPoints.add((CheckPoint)entry.as());
                    }
                }
                --version;
            }
            return checkPoints;
        }
    }
}

