/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.concurrent.WorkSync;
import org.neo4j.helpers.Provider;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.IndexTransactionApplier;
import org.neo4j.unsafe.batchinsert.LabelScanWriter;

public class NeoTransactionIndexApplierTest {
    private static final SchemaIndexProvider.Descriptor INDEX_DESCRIPTOR = new SchemaIndexProvider.Descriptor("in-memory", "1.0");
    private final IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
    private final Provider<LabelScanWriter> labelScanStore = (Provider)Mockito.mock(Provider.class);
    private final CacheAccessBackDoor cacheAccess = (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class);
    private final Collection<DynamicRecord> emptyDynamicRecords = Collections.emptySet();
    private final WorkSync<Provider<LabelScanWriter>, IndexTransactionApplier.LabelUpdateWork> labelScanStoreSynchronizer = new WorkSync(this.labelScanStore);

    @Test
    public void shouldUpdateLabelStoreScanOnNodeCommands() throws Exception {
        ValidatedIndexUpdates indexUpdates = (ValidatedIndexUpdates)Mockito.mock(ValidatedIndexUpdates.class);
        Mockito.when((Object)indexUpdates.hasChanges()).thenReturn((Object)true);
        IndexTransactionApplier applier = new IndexTransactionApplier(this.indexingService, indexUpdates, this.labelScanStoreSynchronizer);
        NodeRecord before = new NodeRecord(11L);
        before.setLabelField(17L, this.emptyDynamicRecords);
        NodeRecord after = new NodeRecord(12L);
        after.setLabelField(18L, this.emptyDynamicRecords);
        Command.NodeCommand command = new Command.NodeCommand().init(before, after);
        Mockito.when((Object)this.labelScanStore.instance()).thenReturn(Mockito.mock(LabelScanWriter.class));
        boolean result = applier.visitNodeCommand(command);
        applier.apply();
        Assert.assertFalse((boolean)result);
        NodeLabelUpdate update = NodeLabelUpdate.labelChanges((long)command.getKey(), (long[])new long[0], (long[])new long[0]);
        List<NodeLabelUpdate> labelUpdates = Arrays.asList(update);
        ((ValidatedIndexUpdates)Mockito.verify((Object)indexUpdates, (VerificationMode)Mockito.times((int)1))).flush();
    }

    @Test
    public void shouldAvoidCallingIndexUpdatesIfNoIndexChanges() throws Exception {
        ValidatedIndexUpdates indexUpdates = (ValidatedIndexUpdates)Mockito.mock(ValidatedIndexUpdates.class);
        Mockito.when((Object)indexUpdates.hasChanges()).thenReturn((Object)false);
        IndexTransactionApplier applier = new IndexTransactionApplier(this.indexingService, indexUpdates, this.labelScanStoreSynchronizer);
        applier.apply();
        ((ValidatedIndexUpdates)Mockito.verify((Object)indexUpdates, (VerificationMode)Mockito.times((int)0))).flush();
    }

    @Test
    public void shouldCreateIndexGivenCreateSchemaRuleCommand() throws IOException {
        IndexRule indexRule = IndexRule.indexRule((long)1L, (int)42, (int)42, (SchemaIndexProvider.Descriptor)INDEX_DESCRIPTOR);
        IndexTransactionApplier applier = new IndexTransactionApplier(this.indexingService, ValidatedIndexUpdates.NONE, this.labelScanStoreSynchronizer);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand();
        command.init(this.emptyDynamicRecords, Collections.singleton(NeoTransactionIndexApplierTest.createdDynamicRecord(1L)), (SchemaRule)indexRule);
        boolean result = applier.visitSchemaRuleCommand(command);
        applier.apply();
        Assert.assertFalse((boolean)result);
        ((IndexingService)Mockito.verify((Object)this.indexingService)).createIndex(indexRule);
    }

    @Test
    public void shouldDropIndexGivenDropSchemaRuleCommand() throws IOException {
        IndexRule indexRule = IndexRule.indexRule((long)1L, (int)42, (int)42, (SchemaIndexProvider.Descriptor)INDEX_DESCRIPTOR);
        IndexTransactionApplier applier = new IndexTransactionApplier(this.indexingService, ValidatedIndexUpdates.NONE, this.labelScanStoreSynchronizer);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand();
        command.init(Collections.singleton(NeoTransactionIndexApplierTest.createdDynamicRecord(1L)), Collections.singleton(DynamicRecord.dynamicRecord((long)1L, (boolean)false)), (SchemaRule)indexRule);
        boolean result = applier.visitSchemaRuleCommand(command);
        applier.apply();
        Assert.assertFalse((boolean)result);
        ((IndexingService)Mockito.verify((Object)this.indexingService)).dropIndex(indexRule);
    }

    private static DynamicRecord createdDynamicRecord(long id) {
        DynamicRecord record = DynamicRecord.dynamicRecord((long)id, (boolean)true);
        record.setCreated();
        return record;
    }
}

