/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.transaction.TransactionCounters;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TransactionMonitorTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldCountCommittedTransactions() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
        try {
            TransactionCounters monitor = (TransactionCounters)db.getDependencyResolver().resolveDependency(TransactionCounters.class);
            long startedBefore = monitor.getNumberOfStartedTransactions();
            long committedBefore = monitor.getNumberOfCommittedTransactions();
            long rolledBackBefore = monitor.getNumberOfRolledbackTransactions();
            try (Transaction tx = db.beginTx();){
                db.createNode();
                tx.success();
            }
            Assert.assertEquals((long)(startedBefore + 1L), (long)monitor.getNumberOfStartedTransactions());
            Assert.assertEquals((long)(committedBefore + 1L), (long)monitor.getNumberOfCommittedTransactions());
            Assert.assertEquals((long)rolledBackBefore, (long)monitor.getNumberOfRolledbackTransactions());
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotCountRolledBackTransactions() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
        try {
            TransactionCounters monitor = (TransactionCounters)db.getDependencyResolver().resolveDependency(TransactionCounters.class);
            long startedBefore = monitor.getNumberOfStartedTransactions();
            long committedBefore = monitor.getNumberOfCommittedTransactions();
            long rolledBackBefore = monitor.getNumberOfRolledbackTransactions();
            try (Transaction tx = db.beginTx();){
                db.createNode();
                tx.failure();
            }
            Assert.assertEquals((long)(startedBefore + 1L), (long)monitor.getNumberOfStartedTransactions());
            Assert.assertEquals((long)committedBefore, (long)monitor.getNumberOfCommittedTransactions());
            Assert.assertEquals((long)(rolledBackBefore + 1L), (long)monitor.getNumberOfRolledbackTransactions());
        }
        finally {
            db.shutdown();
        }
    }
}

