/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v20;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.legacystore.v20.Legacy20RelationshipStoreReader;
import org.neo4j.test.TargetDirectory;

public class Legacy20RelationshipStoreReaderTest {
    private final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();
    @Rule
    public final TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void shouldReadNodeRecords() throws IOException {
        File storeDir = this.testDirectory.graphDbDir();
        MigrationTestUtils.find20FormatStoreDirectory(storeDir);
        Legacy20RelationshipStoreReader relStoreReader = new Legacy20RelationshipStoreReader(this.fs, new File(storeDir, "neostore.relationshipstore.db"));
        Assert.assertEquals((long)1501L, (long)relStoreReader.getMaxId());
        int relCount = 0;
        Iterator iterator = relStoreReader.iterator(0L);
        while (iterator.hasNext()) {
            RelationshipRecord record = (RelationshipRecord)iterator.next();
            if (!record.inUse()) continue;
            ++relCount;
        }
        Assert.assertEquals((long)500L, (long)relCount);
        relStoreReader.close();
    }
}

