/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.impl.store.ProduceUncleanStore;
import org.neo4j.test.ProcessStreamHandler;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestBrokenStoreRecovery {
    @Rule
    public final TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void testTruncatedPropertyStore() throws Exception {
        File storeDir = this.testDirectory.directory("propertyStore");
        Process process = Runtime.getRuntime().exec(new String[]{"java", "-cp", System.getProperty("java.class.path"), ProduceUncleanStore.class.getName(), storeDir.getAbsolutePath()});
        Assert.assertEquals((long)0L, (long)new ProcessStreamHandler(process, true).waitForResult());
        this.trimFileToSize(new File(storeDir, "neostore.propertystore.db"), 42);
        File log = new File(storeDir, "neostore.transaction.db.0");
        this.trimFileToSize(log, 78);
        new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir.getAbsolutePath()).shutdown();
    }

    private void trimFileToSize(File theFile, int toSize) throws IOException {
        FileChannel theChannel = new RandomAccessFile(theFile, "rw").getChannel();
        theChannel.truncate(toSize);
        theChannel.force(false);
        theChannel.close();
    }
}

