/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.store.DumpStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;

public class DumpStoreTest {
    @Test
    public void dumpStoreShouldPrintBufferWithContent() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outStream);
        DumpStore dumpStore = new DumpStore(out);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        for (byte i = 0; i < 10; i = (byte)(i + 1)) {
            buffer.put(i);
        }
        buffer.flip();
        AbstractBaseRecord record = (AbstractBaseRecord)Mockito.mock(AbstractBaseRecord.class);
        dumpStore.dumpHex(record, buffer, 2L, 4);
        Assert.assertEquals((Object)String.format("@ 0x00000008: 00 01 02 03  04 05 06 07  08 09%n", new Object[0]), (Object)outStream.toString());
    }

    @Test
    public void dumpStoreShouldPrintShorterMessageForAllZeroBuffer() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outStream);
        DumpStore dumpStore = new DumpStore(out);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        AbstractBaseRecord record = (AbstractBaseRecord)Mockito.mock(AbstractBaseRecord.class);
        dumpStore.dumpHex(record, buffer, 2L, 4);
        Assert.assertEquals((Object)String.format(": all zeros @ 0x8 - 0xc%n", new Object[0]), (Object)outStream.toString());
    }
}

