/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.kernel.impl.locking.LockCountVisitor;
import org.neo4j.kernel.impl.locking.LockingCompatibilityTestSuite;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;

@Ignore(value="Not a test. This is a compatibility suite, run from LockingCompatibilityTestSuite.")
public class StopCompatibility
extends LockingCompatibilityTestSuite.Compatibility {
    public StopCompatibility(LockingCompatibilityTestSuite suite) {
        super(suite);
    }

    @Test
    public void releaseWriteLockWaitersOnStop() {
        this.clientA.acquireShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.clientB.acquireShared((Locks.ResourceType)ResourceTypes.NODE, 2L);
        this.clientC.acquireShared((Locks.ResourceType)ResourceTypes.NODE, 3L);
        this.acquireExclusive(this.clientB, (Locks.ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.acquireExclusive(this.clientC, (Locks.ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientC.stop();
        this.clientB.stop();
        this.clientA.stop();
        LockCountVisitor lockCountVisitor = new LockCountVisitor();
        this.locks.accept((Locks.Visitor)lockCountVisitor);
        Assert.assertEquals((long)3L, (long)lockCountVisitor.getLockCount());
    }

    @Test
    public void releaseReadLockWaitersOnStop() {
        this.clientA.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.clientB.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, 2L);
        this.acquireShared(this.clientB, (Locks.ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientB.stop();
        this.clientA.stop();
        LockCountVisitor lockCountVisitor = new LockCountVisitor();
        this.locks.accept((Locks.Visitor)lockCountVisitor);
        Assert.assertEquals((long)2L, (long)lockCountVisitor.getLockCount());
    }
}

