/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashSet;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.test.EmbeddedDatabaseRule;

public class TestConcurrentIteratorModification {
    @Rule
    public EmbeddedDatabaseRule dbRule = new EmbeddedDatabaseRule();

    @Test
    public void shouldNotThrowConcurrentModificationExceptionWhenUpdatingWhileIterating() {
        Node node2;
        Node node1;
        GraphDatabaseService graph = this.dbRule.getGraphDatabaseService();
        Label label = DynamicLabel.label((String)"Bird");
        try (Transaction tx = graph.beginTx();){
            node1 = graph.createNode(new Label[]{label});
            node2 = graph.createNode(new Label[]{label});
            tx.success();
        }
        HashSet<Object> result = new HashSet<Object>();
        try (Transaction tx = graph.beginTx();){
            Node node3 = graph.createNode(new Label[]{label});
            ResourceIterator iterator = graph.findNodes(label);
            node3.removeLabel(label);
            graph.createNode(new Label[]{label});
            while (iterator.hasNext()) {
                result.add(iterator.next());
            }
            tx.success();
        }
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Node[]{node1, node2}), result);
    }
}

