/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.function.Consumer;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.api.store.StoreNodeRelationshipCursor;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class StoreNodeRelationshipCursorTest {
    @Test
    public void shouldHandleDenseNodeWithNoRelationships() throws Exception {
        NeoStores stores = (NeoStores)Mockito.mock(NeoStores.class);
        NodeStore nodeStore = (NodeStore)Mockito.mock(NodeStore.class);
        Mockito.when((Object)stores.getNodeStore()).thenReturn((Object)nodeStore);
        RelationshipGroupStore relationshipGroupStore = (RelationshipGroupStore)Mockito.mock(RelationshipGroupStore.class);
        Mockito.when((Object)stores.getRelationshipGroupStore()).thenReturn((Object)relationshipGroupStore);
        StoreNodeRelationshipCursor cursor = new StoreNodeRelationshipCursor(new RelationshipRecord(-1L), stores, new RelationshipGroupRecord(-1L, -1), (StoreStatement)Mockito.mock(StoreStatement.class), (Consumer)Mockito.mock(Consumer.class), LockService.NO_LOCK_SERVICE);
        cursor.init(true, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), 0L, Direction.BOTH);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{relationshipGroupStore});
        Assert.assertFalse((boolean)cursor.next());
    }
}

