/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.subprocess.SubProcess;

public class SchemaRecoveryIT {
    @Rule
    public TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void schemaTransactionsShouldSurviveRecovery() throws Exception {
        String storeDir = this.testDirectory.absolutePath();
        Process process = (Process)new CreateConstraintButDoNotShutDown().start(storeDir);
        process.waitForSchemaTransactionCommitted();
        SubProcess.kill(process);
        GraphDatabaseService recoveredDatabase = new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir);
        Assert.assertEquals((long)1L, (long)this.constraints(recoveredDatabase).size());
        Assert.assertEquals((long)1L, (long)this.indexes(recoveredDatabase).size());
        recoveredDatabase.shutdown();
    }

    private List<ConstraintDefinition> constraints(GraphDatabaseService database) {
        try (Transaction ignored = database.beginTx();){
            List list = IteratorUtil.asList((Iterable)database.schema().getConstraints());
            return list;
        }
    }

    private List<IndexDefinition> indexes(GraphDatabaseService database) {
        try (Transaction ignored = database.beginTx();){
            List list = IteratorUtil.asList((Iterable)database.schema().getIndexes());
            return list;
        }
    }

    static class CreateConstraintButDoNotShutDown
    extends SubProcess<Process, String>
    implements Process {
        private volatile boolean started = false;

        CreateConstraintButDoNotShutDown() {
        }

        @Override
        protected void startup(String storeDir) throws Throwable {
            GraphDatabaseService database = new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir);
            try (Transaction transaction = database.beginTx();){
                database.schema().constraintFor(DynamicLabel.label((String)"User")).assertPropertyIsUnique("uuid").create();
                transaction.success();
            }
            this.started = true;
        }

        @Override
        public void waitForSchemaTransactionCommitted() throws InterruptedException {
            while (!this.started) {
                Thread.sleep(10L);
            }
        }
    }

    public static interface Process {
        public void waitForSchemaTransactionCommitted() throws InterruptedException;
    }
}

