/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.function.Function;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.SchemaWriteOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.Kernel;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;

public class KernelIT
extends KernelIntegrationTest {
    @Test
    public void mixingBeansApiWithKernelAPI() throws Exception {
        Transaction transaction = this.db.beginTx();
        Statement statement = this.statementContextSupplier.get();
        Node node = this.db.createNode();
        int labelId = statement.dataWriteOperations().labelGetOrCreateForName("labello");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId);
        statement.close();
        transaction.success();
        transaction.close();
    }

    @Test
    public void mixingBeansApiWithKernelAPIForNestedTransaction() throws Exception {
        Transaction outerTx = this.db.beginTx();
        Statement statement = this.statementContextSupplier.get();
        Node node = this.db.createNode();
        int labelId = statement.dataWriteOperations().labelGetOrCreateForName("labello");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId);
        statement.close();
        outerTx.close();
    }

    @Test
    public void changesInTransactionContextShouldBeRolledBackWhenTxIsRolledBack() throws Exception {
        Transaction tx = this.db.beginTx();
        Statement statement = this.statementContextSupplier.get();
        Node node = this.db.createNode();
        int labelId = statement.dataWriteOperations().labelGetOrCreateForName("labello");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId);
        statement.close();
        tx.close();
        tx = this.db.beginTx();
        statement = this.statementContextSupplier.get();
        try {
            statement.readOperations().nodeHasLabel(node.getId(), labelId);
            Assert.fail((String)"should have thrown exception");
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotBeAbleToCommitIfFailedTransactionContext() throws Exception {
        Statement statement;
        Throwable throwable;
        Node node = null;
        int labelId = -1;
        TransactionFailureException expectedException = null;
        try {
            throwable = null;
            try (Transaction transaction = this.db.beginTx();){
                statement = this.statementContextSupplier.get();
                node = this.db.createNode();
                labelId = statement.dataWriteOperations().labelGetOrCreateForName("labello");
                statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId);
                statement.close();
                transaction.failure();
                transaction.success();
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
        }
        catch (TransactionFailureException e) {
            expectedException = e;
        }
        finally {
            Assert.assertNotNull((String)"Should have failed", (Object)((Object)expectedException));
        }
        throwable = null;
        try (Transaction tx = this.db.beginTx();){
            statement = this.statementContextSupplier.get();
            try {
                statement.readOperations().nodeHasLabel(node.getId(), labelId);
                Assert.fail((String)"should have thrown exception");
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    @Test
    public void transactionStateShouldRemovePreviouslyAddedLabel() throws Exception {
        Transaction tx = this.db.beginTx();
        Statement statement = this.statementContextSupplier.get();
        Node node = this.db.createNode();
        int labelId1 = statement.dataWriteOperations().labelGetOrCreateForName("labello1");
        int labelId2 = statement.dataWriteOperations().labelGetOrCreateForName("labello2");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId1);
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId2);
        statement.dataWriteOperations().nodeRemoveLabel(node.getId(), labelId2);
        statement.close();
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        statement = this.statementContextSupplier.get();
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Integer[]{labelId1}), (Object)IteratorUtil.asSet((PrimitiveIntIterator)statement.readOperations().nodeGetLabels(node.getId())));
        tx.close();
    }

    @Test
    public void transactionStateShouldReflectRemovingAddedLabelImmediately() throws Exception {
        Transaction tx = this.db.beginTx();
        Statement statement = this.statementContextSupplier.get();
        Node node = this.db.createNode();
        int labelId1 = statement.dataWriteOperations().labelGetOrCreateForName("labello1");
        int labelId2 = statement.dataWriteOperations().labelGetOrCreateForName("labello2");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId1);
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId2);
        statement.dataWriteOperations().nodeRemoveLabel(node.getId(), labelId2);
        Assert.assertFalse((boolean)statement.readOperations().nodeHasLabel(node.getId(), labelId2));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Integer[]{labelId1}), (Object)IteratorUtil.asSet((PrimitiveIntIterator)statement.readOperations().nodeGetLabels(node.getId())));
        statement.close();
        tx.success();
        tx.close();
    }

    @Test
    public void transactionStateShouldReflectRemovingLabelImmediately() throws Exception {
        Transaction tx = this.db.beginTx();
        Statement statement = this.statementContextSupplier.get();
        Node node = this.db.createNode();
        int labelId1 = statement.dataWriteOperations().labelGetOrCreateForName("labello1");
        int labelId2 = statement.dataWriteOperations().labelGetOrCreateForName("labello2");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId1);
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId2);
        statement.close();
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        statement = this.statementContextSupplier.get();
        statement.dataWriteOperations().nodeRemoveLabel(node.getId(), labelId2);
        PrimitiveIntIterator labelsIterator = statement.readOperations().nodeGetLabels(node.getId());
        Set labels = IteratorUtil.asSet((PrimitiveIntIterator)labelsIterator);
        Assert.assertFalse((boolean)statement.readOperations().nodeHasLabel(node.getId(), labelId2));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Integer[]{labelId1}), (Object)labels);
        statement.close();
        tx.success();
        tx.close();
    }

    @Test
    public void labelShouldBeRemovedAfterCommit() throws Exception {
        Transaction tx = this.db.beginTx();
        Statement statement = this.statementContextSupplier.get();
        Node node = this.db.createNode();
        int labelId1 = statement.dataWriteOperations().labelGetOrCreateForName("labello1");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId1);
        statement.close();
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        statement = this.statementContextSupplier.get();
        statement.dataWriteOperations().nodeRemoveLabel(node.getId(), labelId1);
        statement.close();
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        statement = this.statementContextSupplier.get();
        PrimitiveIntIterator labels = statement.readOperations().nodeGetLabels(node.getId());
        statement.close();
        tx.success();
        tx.close();
        Assert.assertThat((Object)IteratorUtil.asSet((PrimitiveIntIterator)labels), (Matcher)Matchers.equalTo(Collections.emptySet()));
    }

    @Test
    public void addingNewLabelToNodeShouldRespondTrue() throws Exception {
        Transaction tx = this.db.beginTx();
        Node node = this.db.createNode();
        Statement statement = this.statementContextSupplier.get();
        int labelId = statement.dataWriteOperations().labelGetOrCreateForName("mylabel");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId);
        statement.close();
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        statement = this.statementContextSupplier.get();
        boolean added = statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId);
        tx.close();
        Assert.assertFalse((String)"Shouldn't have been added now", (boolean)added);
    }

    @Test
    public void addingExistingLabelToNodeShouldRespondFalse() throws Exception {
        Transaction tx = this.db.beginTx();
        Node node = this.db.createNode();
        Statement statement = this.statementContextSupplier.get();
        int labelId = statement.dataWriteOperations().labelGetOrCreateForName("mylabel");
        statement.close();
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        statement = this.statementContextSupplier.get();
        boolean added = statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId);
        tx.close();
        Assert.assertTrue((String)"Should have been added now", (boolean)added);
    }

    @Test
    public void removingExistingLabelFromNodeShouldRespondTrue() throws Exception {
        Transaction tx = this.db.beginTx();
        Node node = this.db.createNode();
        Statement statement = this.statementContextSupplier.get();
        int labelId = statement.dataWriteOperations().labelGetOrCreateForName("mylabel");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId);
        statement.close();
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        statement = this.statementContextSupplier.get();
        boolean removed = statement.dataWriteOperations().nodeRemoveLabel(node.getId(), labelId);
        Assert.assertTrue((String)"Should have been removed now", (boolean)removed);
        tx.close();
    }

    @Test
    public void removingNonExistentLabelFromNodeShouldRespondFalse() throws Exception {
        Transaction tx = this.db.beginTx();
        Node node = this.db.createNode();
        Statement statement = this.statementContextSupplier.get();
        int labelId = statement.dataWriteOperations().labelGetOrCreateForName("mylabel");
        statement.close();
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        statement = this.statementContextSupplier.get();
        boolean removed = statement.dataWriteOperations().nodeRemoveLabel(node.getId(), labelId);
        Assert.assertFalse((String)"Shouldn't have been removed now", (boolean)removed);
        tx.close();
    }

    @Test
    public void deletingNodeWithLabelsShouldHaveThoseLabelRemovalsReflectedInTransaction() throws Exception {
        Transaction tx = this.db.beginTx();
        Label label = DynamicLabel.label((String)"labello");
        Node node = this.db.createNode(new Label[]{label});
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        Statement statement = this.statementContextSupplier.get();
        statement.dataWriteOperations().nodeDelete(node.getId());
        int labelId = statement.readOperations().labelGetForName(label.name());
        try {
            statement.readOperations().nodeGetLabels(node.getId());
            Assert.fail();
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
        try {
            statement.readOperations().nodeHasLabel(node.getId(), labelId);
            Assert.fail();
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
        Set nodes = IteratorUtil.asSet((PrimitiveLongIterator)statement.readOperations().nodesGetForLabel(labelId));
        statement.close();
        tx.success();
        tx.close();
        Assert.assertEquals((Object)IteratorUtil.emptySetOf(Long.class), (Object)nodes);
    }

    @Test
    public void deletingNodeWithLabelsShouldHaveRemovalReflectedInLabelScans() throws Exception {
        Transaction tx = this.db.beginTx();
        Label label = DynamicLabel.label((String)"labello");
        Node node = this.db.createNode(new Label[]{label});
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        node.delete();
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        Statement statement = this.statementContextSupplier.get();
        int labelId = statement.readOperations().labelGetForName(label.name());
        PrimitiveLongIterator nodes = statement.readOperations().nodesGetForLabel(labelId);
        Set nodeSet = IteratorUtil.asSet((PrimitiveLongIterator)nodes);
        tx.success();
        tx.close();
        Assert.assertThat((Object)nodeSet, (Matcher)Matchers.equalTo(Collections.emptySet()));
    }

    @Test
    public void schemaStateShouldBeEvictedOnIndexComingOnline() throws Exception {
        this.schemaWriteOperationsInNewTransaction();
        this.getOrCreateSchemaState("my key", "my state");
        this.commit();
        this.createIndex(this.schemaWriteOperationsInNewTransaction());
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexOnline((IndexDefinition)this.db.schema().getIndexes().iterator().next(), 20L, TimeUnit.SECONDS);
            tx.success();
        }
        Assert.assertFalse((boolean)this.schemaStateContains("my key"));
    }

    @Test
    public void schemaStateShouldBeEvictedOnIndexDropped() throws Exception {
        IndexDescriptor idx = this.createIndex(this.schemaWriteOperationsInNewTransaction());
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexOnline((IndexDefinition)this.db.schema().getIndexes().iterator().next(), 20L, TimeUnit.SECONDS);
            this.getOrCreateSchemaState("my key", "some state");
            tx.success();
        }
        this.schemaWriteOperationsInNewTransaction().indexDrop(idx);
        this.commit();
        Assert.assertFalse((boolean)this.schemaStateContains("my key"));
    }

    @Test
    public void shouldKillTransactionsOnShutdown() throws Throwable {
        Assume.assumeThat((Object)this.kernel, (Matcher)Matchers.instanceOf(Kernel.class));
        try (KernelTransaction tx = this.kernel.newTransaction();){
            ((Kernel)this.kernel).stop();
            tx.acquireStatement().readOperations().nodeExists(0L);
            Assert.fail((String)"Should have been terminated.");
        }
        catch (TransactionTerminatedException transactionTerminatedException) {
            // empty catch block
        }
    }

    private IndexDescriptor createIndex(SchemaWriteOperations schemaWriteOperations) throws SchemaKernelException {
        return schemaWriteOperations.indexCreate(schemaWriteOperations.labelGetOrCreateForName("hello"), schemaWriteOperations.propertyKeyGetOrCreateForName("hepp"));
    }

    private String getOrCreateSchemaState(String key, final String maybeSetThisState) {
        try (Transaction tx = this.db.beginTx();){
            Statement statement = this.statementContextSupplier.get();
            String state = (String)statement.readOperations().schemaStateGetOrCreate((Object)key, (Function)new Function<String, String>(){

                public String apply(String s) {
                    return maybeSetThisState;
                }
            });
            tx.success();
            String string = state;
            return string;
        }
    }

    private boolean schemaStateContains(String key) {
        try (Transaction tx = this.db.beginTx();){
            Statement statement = this.statementContextSupplier.get();
            final AtomicBoolean result = new AtomicBoolean(true);
            statement.readOperations().schemaStateGetOrCreate((Object)key, (Function)new Function<String, Object>(){

                public Object apply(String s) {
                    result.set(false);
                    return null;
                }
            });
            tx.success();
            boolean bl = result.get();
            return bl;
        }
    }
}

