/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.api.index.sampling.NonUniqueIndexSampler;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;

public class NonUniqueIndexSamplerTest {
    private final String value = "aaa";

    @Test
    public void shouldSampleNothing() {
        NonUniqueIndexSampler sampler = new NonUniqueIndexSampler(10);
        this.assertSampledValues(sampler, 0L, 0L, 0L);
    }

    @Test
    public void shouldSampleASingleValue() {
        NonUniqueIndexSampler sampler = new NonUniqueIndexSampler(10);
        sampler.include("aaa", 2L);
        this.assertSampledValues(sampler, 2L, 1L, 2L);
    }

    @Test
    public void shouldSampleDuplicateValues() {
        NonUniqueIndexSampler sampler = new NonUniqueIndexSampler(10);
        sampler.include("aaa", 5L);
        sampler.include("aaa", 4L);
        sampler.include("bbb", 3L);
        this.assertSampledValues(sampler, 12L, 2L, 12L);
    }

    @Test
    public void shouldDivideTheSamplingInStepsNotBiggerThanBatchSize() {
        NonUniqueIndexSampler sampler = new NonUniqueIndexSampler(1);
        sampler.include("aaa", 5L);
        sampler.include("aaa", 4L);
        sampler.include("bbb", 3L);
        int expectedSampledSize = 4;
        this.assertSampledValues(sampler, 12L, 1L, expectedSampledSize);
    }

    @Test
    public void shouldExcludeValuesFromTheCurrentSampling1() {
        NonUniqueIndexSampler sampler = new NonUniqueIndexSampler(10);
        sampler.include("aaa", 5L);
        sampler.include("aaa", 4L);
        sampler.include("bbb", 3L);
        sampler.exclude("aaa", 3L);
        this.assertSampledValues(sampler, 9L, 2L, 9L);
    }

    @Test
    public void shouldExcludeValuesFromTheCurrentSampling2() {
        NonUniqueIndexSampler sampler = new NonUniqueIndexSampler(10);
        sampler.include("aaa", 1L);
        sampler.include("aaa", 4L);
        sampler.include("bbb", 1L);
        sampler.exclude("aaa", 4L);
        this.assertSampledValues(sampler, 2L, 2L, 2L);
    }

    @Test
    public void shouldDoNothingWhenExcludingAValueInAnEmptySample() {
        NonUniqueIndexSampler sampler = new NonUniqueIndexSampler(10);
        sampler.exclude("aaa", 1L);
        sampler.include("aaa", 1L);
        this.assertSampledValues(sampler, 1L, 1L, 1L);
    }

    private void assertSampledValues(NonUniqueIndexSampler sampler, long expectedIndexSize, long expectedUniqueValues, long expectedSampledSize) {
        Register.DoubleLongRegister register = Registers.newDoubleLongRegister();
        long indexSize = sampler.result((Register.DoubleLong.Out)register);
        Assert.assertEquals((long)expectedUniqueValues, (long)register.readFirst());
        Assert.assertEquals((long)expectedSampledSize, (long)register.readSecond());
        Assert.assertEquals((long)expectedIndexSize, (long)indexSize);
    }
}

