/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.LookupFilter;
import org.neo4j.kernel.impl.api.operations.EntityOperations;

public class NumericRangeMatchPredicateTest {
    @Test
    public void testInclusiveLowerInclusiveUpper() {
        LookupFilter.NumericRangeMatchPredicate range = this.createRange(11, true, 13, true);
        Assert.assertFalse((boolean)range.inRange((Object)10));
        Assert.assertTrue((boolean)range.inRange((Object)11));
        Assert.assertTrue((boolean)range.inRange((Object)12));
        Assert.assertTrue((boolean)range.inRange((Object)13));
        Assert.assertFalse((boolean)range.inRange((Object)14));
    }

    @Test
    public void testExclusiveLowerExclusiveLower() {
        LookupFilter.NumericRangeMatchPredicate range = this.createRange(11, false, 13, false);
        Assert.assertFalse((boolean)range.inRange((Object)11));
        Assert.assertTrue((boolean)range.inRange((Object)12));
        Assert.assertFalse((boolean)range.inRange((Object)13));
    }

    @Test
    public void testInclusiveLowerExclusiveUpper() {
        LookupFilter.NumericRangeMatchPredicate range = this.createRange(11, true, 13, false);
        Assert.assertFalse((boolean)range.inRange((Object)10));
        Assert.assertTrue((boolean)range.inRange((Object)11));
        Assert.assertTrue((boolean)range.inRange((Object)12));
        Assert.assertFalse((boolean)range.inRange((Object)13));
    }

    @Test
    public void testExclusiveLowerInclusiveUpper() {
        LookupFilter.NumericRangeMatchPredicate range = this.createRange(11, false, 13, true);
        Assert.assertFalse((boolean)range.inRange((Object)11));
        Assert.assertTrue((boolean)range.inRange((Object)12));
        Assert.assertTrue((boolean)range.inRange((Object)13));
        Assert.assertFalse((boolean)range.inRange((Object)14));
    }

    @Test
    public void testLowerNullValue() {
        LookupFilter.NumericRangeMatchPredicate range = this.createRange(null, true, 13, true);
        Assert.assertTrue((boolean)range.inRange((Object)10));
        Assert.assertTrue((boolean)range.inRange((Object)11));
        Assert.assertTrue((boolean)range.inRange((Object)12));
        Assert.assertTrue((boolean)range.inRange((Object)13));
        Assert.assertFalse((boolean)range.inRange((Object)14));
    }

    @Test
    public void testUpperNullValue() {
        LookupFilter.NumericRangeMatchPredicate range = this.createRange(11, true, null, true);
        Assert.assertFalse((boolean)range.inRange((Object)10));
        Assert.assertTrue((boolean)range.inRange((Object)11));
        Assert.assertTrue((boolean)range.inRange((Object)12));
        Assert.assertTrue((boolean)range.inRange((Object)13));
        Assert.assertTrue((boolean)range.inRange((Object)14));
    }

    @Test
    public void testComparingBigDoublesAndLongs() {
        LookupFilter.NumericRangeMatchPredicate range = this.createRange(0x20000000000001L, true, null, true);
        Assert.assertFalse((boolean)range.inRange((Object)9.007199254740992E15));
    }

    @Test
    public void testNullValue() {
        LookupFilter.NumericRangeMatchPredicate range = this.createRange(11, true, 13, true);
        Assert.assertFalse((boolean)range.inRange(null));
    }

    private LookupFilter.NumericRangeMatchPredicate createRange(Number lower, boolean includeLower, Number upper, boolean includeUpper) {
        return new LookupFilter.NumericRangeMatchPredicate((EntityOperations)Mockito.mock(EntityOperations.class), (KernelStatement)Mockito.mock(KernelStatement.class), 11, lower, includeLower, upper, includeUpper);
    }
}

